/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui.component;

import com.gtnewhorizons.wdmla.api.ui.IComponent;
import com.gtnewhorizons.wdmla.api.ui.IDrawable;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.api.ui.sizer.IPadding;
import com.gtnewhorizons.wdmla.api.ui.sizer.ISize;
import com.gtnewhorizons.wdmla.impl.ui.component.Component;
import com.gtnewhorizons.wdmla.impl.ui.component.HPanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.ItemComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.ProgressComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.TextComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.VPanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Area;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Padding;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class TooltipComponent
extends Component
implements ITooltip {
    protected List<IComponent> children;
    public static final IPadding DEFAULT_PROGRESS_DESCRIPTION_PADDING = new Padding(2, 1, 2, 3);

    protected TooltipComponent(List<IComponent> children, IPadding padding, ISize size, IDrawable foreground) {
        super(padding, size, foreground);
        this.children = children;
    }

    @Override
    public TooltipComponent padding(@NotNull IPadding padding) {
        this.padding = padding;
        return this;
    }

    @Override
    public TooltipComponent size(@NotNull ISize size) {
        this.size = size;
        return this;
    }

    @Override
    public void tick(float x, float y) {
        this.foreground.draw(new Area(x + this.padding.getLeft(), y + this.padding.getTop(), this.size.getW(), this.size.getH()));
        for (IComponent child : this.children) {
            child.tick(x + this.padding.getLeft(), y + this.padding.getTop());
        }
    }

    @Override
    public ITooltip child(@NotNull IComponent child) {
        this.children.add(child);
        return this;
    }

    @Override
    public ITooltip text(String text, IPadding padding) {
        Component c = new TextComponent(text).padding(padding);
        this.children.add(c);
        return this;
    }

    @Override
    public ITooltip text(String text) {
        TextComponent c = new TextComponent(text);
        this.children.add(c);
        return this;
    }

    @Override
    public ITooltip vertical() {
        VPanelComponent c = new VPanelComponent();
        this.children.add(c);
        return c;
    }

    @Override
    public ITooltip horizontal() {
        HPanelComponent c = new HPanelComponent();
        this.children.add(c);
        return c;
    }

    @Override
    public ITooltip item(ItemStack stack, IPadding padding, ISize size) {
        TooltipComponent c = new ItemComponent(stack).padding(padding).size(size);
        this.children.add(c);
        return this;
    }

    @Override
    public ITooltip item(ItemStack stack) {
        ItemComponent c = new ItemComponent(stack);
        this.children.add(c);
        return this;
    }

    @Override
    public ITooltip progress(long current, long max, String progressText) {
        ITooltip c = new ProgressComponent(current, max).child(new TextComponent(progressText).padding(DEFAULT_PROGRESS_DESCRIPTION_PADDING));
        this.children.add(c);
        return this;
    }

    @Override
    public int childrenSize() {
        return this.children.size();
    }

    @Override
    public ITooltip clear() {
        this.children.clear();
        return this;
    }

    @Override
    public ITooltip tag(ResourceLocation tag) {
        this.tag = tag;
        return this;
    }

    @Override
    public IComponent getChildWithTag(ResourceLocation tag) {
        for (int i = 0; i < this.children.size(); ++i) {
            ITooltip tooltipChild;
            IComponent nestedChild;
            IComponent child = this.children.get(i);
            if (tag.equals((Object)child.getTag())) {
                return child;
            }
            if (!(child instanceof ITooltip) || (nestedChild = (tooltipChild = (ITooltip)child).getChildWithTag(tag)) == null) continue;
            return nestedChild;
        }
        return null;
    }

    @Override
    public boolean replaceChildWithTag(@NotNull ResourceLocation tag, IComponent newChild) {
        for (int i = 0; i < this.children.size(); ++i) {
            ITooltip tooltipChild;
            boolean isReplaced;
            IComponent child = this.children.get(i);
            if (tag.equals((Object)child.getTag())) {
                this.children.set(i, newChild);
                return true;
            }
            if (!(child instanceof ITooltip) || !(isReplaced = (tooltipChild = (ITooltip)child).replaceChildWithTag(tag, newChild))) continue;
            return true;
        }
        return false;
    }
}

