/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui.component;

import com.gtnewhorizons.wdmla.api.ui.IComponent;
import com.gtnewhorizons.wdmla.api.ui.sizer.ISize;
import com.gtnewhorizons.wdmla.impl.ui.component.TooltipComponent;
import com.gtnewhorizons.wdmla.impl.ui.drawable.HealthDrawable;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Padding;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Size;
import java.util.ArrayList;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.utils.Constants;
import org.jetbrains.annotations.NotNull;

public class HealthComponent
extends TooltipComponent {
    public HealthComponent(float health, float maxHealth) {
        this(ConfigHandler.instance().getConfig("general", Constants.CFG_WAILA_NHEARTS, 20), health, maxHealth);
    }

    public HealthComponent(int maxHeartsPerLine, float health, float maxHealth) {
        super(new ArrayList<IComponent>(), new Padding(), new Size(0, 0), new HealthDrawable(maxHeartsPerLine, health, maxHealth));
        super.size(this.getSize(maxHeartsPerLine, maxHealth));
    }

    public Size getSize(int maxHeartsPerLine, float maxHealth) {
        int heartsPerLine = (int)Math.min((double)maxHeartsPerLine, Math.ceil(maxHealth));
        int nLines = (int)Math.ceil(maxHealth / (float)maxHeartsPerLine);
        return new Size(8 * heartsPerLine, 10 * nLines - 2);
    }

    @Override
    public TooltipComponent size(@NotNull ISize size) {
        throw new IllegalArgumentException("You can't set the size of this component!");
    }
}

