/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui.component;

import com.gtnewhorizons.wdmla.api.ui.IComponent;
import com.gtnewhorizons.wdmla.api.ui.sizer.ISize;
import com.gtnewhorizons.wdmla.impl.ui.component.PanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Area;
import org.jetbrains.annotations.NotNull;

public class HPanelComponent
extends PanelComponent {
    @Override
    public void tick(float x, float y) {
        this.foreground.draw(new Area(x + this.padding.getLeft(), y + this.padding.getTop(), this.getWidth(), this.getHeight()));
        float totHeight = this.getHeight();
        float cx = x + this.padding.getLeft() + this.bgStyle.getBorderThickness();
        for (int i = 0; i < this.children.size(); ++i) {
            float h = ((IComponent)this.children.get(i)).getHeight();
            float cy = y;
            switch (this.style.getAlignment()) {
                case TOPLEFT: {
                    cy = y + this.padding.getTop() + this.bgStyle.getBorderThickness();
                    break;
                }
                case CENTER: {
                    cy = y + (totHeight - h) / 2.0f;
                    break;
                }
                case BOTTOMRIGHT: {
                    cy = y + totHeight - h - this.padding.getBottom() - this.bgStyle.getBorderThickness();
                }
            }
            ((IComponent)this.children.get(i)).tick(cx, cy);
            if (i >= this.children.size() - 1) continue;
            cx += ((IComponent)this.children.get(i)).getWidth() + this.style.getSpacing();
        }
    }

    @Override
    public float getWidth() {
        float w = 0.0f;
        for (IComponent child : this.children) {
            w += child.getWidth();
        }
        float totalSpacing = this.children.isEmpty() ? 0.0f : this.style.getSpacing() * (float)(this.children.size() - 1);
        return this.padding.getLeft() + w + totalSpacing + this.padding.getRight() + this.bgStyle.getBorderThickness() * 2.0f;
    }

    @Override
    public float getHeight() {
        float h = 0.0f;
        for (IComponent child : this.children) {
            float ww = child.getHeight();
            if (!(ww > h)) continue;
            h = ww;
        }
        return this.padding.getTop() + h + this.padding.getBottom() + this.bgStyle.getBorderThickness() * 2.0f;
    }

    @Override
    public PanelComponent size(@NotNull ISize size) {
        throw new IllegalArgumentException("Horizontal Panel is auto sized.");
    }
}

