/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.config;

import com.gtnewhorizons.wdmla.api.TextColors;
import com.gtnewhorizons.wdmla.api.Theme;
import com.gtnewhorizons.wdmla.api.provider.IComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.ITimeFormatConfigurable;
import com.gtnewhorizons.wdmla.config.General;
import com.gtnewhorizons.wdmla.impl.WDMlaClientRegistration;
import com.gtnewhorizons.wdmla.impl.WDMlaCommonRegistration;
import com.gtnewhorizons.wdmla.impl.format.TimeFormattingPattern;
import com.gtnewhorizons.wdmla.impl.ui.DefaultThemes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class WDMlaConfig
extends Configuration {
    @SideOnly(value=Side.CLIENT)
    private static WDMlaConfig _instance;

    public WDMlaConfig(File configFile) {
        super(configFile);
        _instance = this;
    }

    public static WDMlaConfig instance() {
        return _instance;
    }

    public void reloadConfig() {
        this.getCategory("plugins_autogen").setLanguageKey("option.wdmla.autogen.category");
        this.getCategory("plugins_autogen.core").setLanguageKey("provider.wdmla.core.category");
        this.reloadProviderAutogenConfigs();
        this.reloadTheme();
    }

    public void reloadProviderAutogenConfigs() {
        for (IComponentProvider provider : WDMlaClientRegistration.instance().getAllProvidersWithoutInfo()) {
            this.getCategory(provider.getConfigCategory()).setLanguageKey(provider.getLangKey());
            this.isProviderEnabled(provider);
            WDMlaCommonRegistration.instance().priorities.put(provider, this.getProviderPriority(provider));
            if (!(provider instanceof ITimeFormatConfigurable)) continue;
            ITimeFormatConfigurable timeFormat = (ITimeFormatConfigurable)((Object)provider);
            this.getTimeFormatter(timeFormat);
        }
    }

    public boolean isProviderEnabled(IComponentProvider<?> provider) {
        Property prop = this.get(provider.getConfigCategory(), "option.wdmla.autogen.enabled", provider.enabledByDefault(), "");
        if (!provider.canToggleInGui()) {
            prop.setShowInGui(false);
        }
        return prop.getBoolean();
    }

    public int getProviderPriority(IComponentProvider<?> provider) {
        if (provider.isPriorityFixed()) {
            return provider.getDefaultPriority();
        }
        Property prop = this.get(provider.getConfigCategory(), "option.wdmla.autogen.priority", provider.getDefaultPriority(), "");
        if (!provider.canPrioritizeInGui()) {
            prop.setShowInGui(false);
        }
        return prop.getInt();
    }

    public TimeFormattingPattern getTimeFormatter(ITimeFormatConfigurable instance) {
        return this.loadEnum(instance.getConfigCategory(), "option.wdmla.autogen.time.format", instance.getDefaultTimeFormatter(), "");
    }

    private void reloadTheme() {
        Theme custom = DefaultThemes.CUSTOM.get();
        custom.textColors = new TextColors(0, General.textColor.info, General.textColor.title, General.textColor.success, General.textColor.warning, General.textColor.danger, General.textColor.failure, General.textColor.modName);
    }

    public <T extends Enum<T>> T loadEnum(String category, String name, T defaultValue, String comment) {
        Class<T> enumType = defaultValue.getDeclaringClass();
        return Enum.valueOf(enumType, this.getString(name, category, defaultValue.toString(), comment, (String[])Arrays.stream((Enum[])enumType.getEnumConstants()).map(Enum::toString).toArray(String[]::new)));
    }
}

