/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.api.harvestability;

import com.gtnewhorizons.wdmla.api.harvestability.HarvestLevel;
import java.util.List;
import java.util.Objects;
import joptsimple.internal.Strings;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.Nullable;

public class EffectiveTool {
    public static final EffectiveTool NO_TOOL = new EffectiveTool(null, null);
    public static final EffectiveTool CANNOT_HARVEST = new EffectiveTool("unbreakable", null);
    protected final String value;
    @Nullable
    private final List<ItemStack> iconList;

    public EffectiveTool(String name, @Nullable List<ItemStack> iconList) {
        this.value = name;
        this.iconList = iconList;
    }

    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.value) && this.value.length() > 1;
    }

    public HarvestLevel getHarvestLevel(Block block, int meta) {
        int rawLevel = block.getHarvestLevel(meta);
        if (this.isValid() && rawLevel < 0) {
            rawLevel = 0;
        }
        return new HarvestLevel(rawLevel);
    }

    public boolean isToolInstance(ItemStack tool) {
        return tool.func_77973_b().getToolClasses(tool).contains(this.value);
    }

    public boolean isSameTool(EffectiveTool anotherTool) {
        return Objects.equals(this.value, anotherTool.value);
    }

    public boolean hasIconRegistered() {
        return this.iconList != null;
    }

    public ItemStack getIcon(HarvestLevel harvestLevel) {
        if (!harvestLevel.isToolRequired() || !this.isValid()) {
            return null;
        }
        ItemStack icon = harvestLevel.getIconFromList(this.iconList);
        if (icon == null && !this.isSameTool(CANNOT_HARVEST)) {
            icon = new ItemStack(Blocks.field_150411_aY);
        }
        return icon;
    }

    public String getLocalizedName() {
        if (StatCollector.func_94522_b((String)("hud.msg.wdmla.toolclass." + this.value))) {
            return StatCollector.func_74838_a((String)("hud.msg.wdmla.toolclass." + this.value));
        }
        if (this.isValid()) {
            return this.value.substring(0, 1).toUpperCase() + this.value.substring(1);
        }
        return null;
    }
}

