/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.api.accessor;

import com.gtnewhorizons.wdmla.api.accessor.AccessorImpl;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.provider.IServerDataProvider;
import com.gtnewhorizons.wdmla.impl.WDMlaCommonRegistration;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.util.function.Supplier;
import mcp.mobius.waila.network.Message0x01TERequest;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class BlockAccessorImpl
extends AccessorImpl
implements BlockAccessor {
    private final Block block;
    @Nullable
    private final Supplier<TileEntity> tileEntity;
    private final int metadata;
    private final ItemStack itemForm;

    public BlockAccessorImpl(Builder builder) {
        super(builder.level, builder.player, builder.hit, builder.connected, builder.showDetails, builder.serverData);
        this.block = builder.block;
        this.tileEntity = builder.tileEntity;
        this.metadata = builder.metadata;
        this.itemForm = builder.itemForm;
    }

    public static void handleRequest(ChannelHandlerContext ctx, NBTTagCompound tag, Message0x01TERequest msg) {
        WorldServer world = DimensionManager.getWorld((int)msg.dim);
        TileEntity entity = world.func_147438_o(msg.posX, msg.posY, msg.posZ);
        Block block = world.func_147439_a(msg.posX, msg.posY, msg.posZ);
        int meta = world.func_72805_g(msg.posX, msg.posY, msg.posZ);
        EntityPlayerMP player = ((NetHandlerPlayServer)ctx.channel().attr((AttributeKey)NetworkRegistry.NET_HANDLER).get()).field_147369_b;
        for (IServerDataProvider<BlockAccessor> provider : WDMlaCommonRegistration.instance().getBlockNBTProviders(block, entity)) {
            try {
                provider.appendServerData(tag, new Builder().level((World)world).player((EntityPlayer)player).block(block).tileEntity(entity).meta(meta).build());
            }
            catch (AbstractMethodError | NoSuchMethodError incompatibleClassChangeError) {}
        }
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    @Nullable
    public TileEntity getTileEntity() {
        return this.tileEntity == null ? null : this.tileEntity.get();
    }

    @Override
    @Nullable
    public Object getTarget() {
        return this.getTileEntity();
    }

    @Override
    public int getMetadata() {
        return this.metadata;
    }

    @Override
    public ItemStack getItemForm() {
        return this.itemForm;
    }

    @Override
    public boolean verifyData(NBTTagCompound data) {
        if (!this.verify) {
            return true;
        }
        int x = data.func_74762_e("x");
        int y = data.func_74762_e("y");
        int z = data.func_74762_e("z");
        MovingObjectPosition hitPos = this.getHitResult();
        return x == hitPos.field_72311_b && y == hitPos.field_72312_c && z == hitPos.field_72309_d;
    }

    public static class Builder
    implements BlockAccessor.Builder {
        private World level;
        private EntityPlayer player;
        private NBTTagCompound serverData;
        private boolean connected;
        private boolean showDetails;
        private MovingObjectPosition hit;
        private Block block = Blocks.field_150350_a;
        private Supplier<TileEntity> tileEntity;
        private int metadata;
        private ItemStack itemForm;
        private boolean verify;

        @Override
        public Builder level(World level) {
            this.level = level;
            return this;
        }

        @Override
        public Builder player(EntityPlayer player) {
            this.player = player;
            return this;
        }

        @Override
        public Builder serverData(NBTTagCompound serverData) {
            this.serverData = serverData;
            return this;
        }

        @Override
        public Builder serverConnected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public Builder showDetails(boolean showDetails) {
            this.showDetails = showDetails;
            return this;
        }

        @Override
        public Builder hit(MovingObjectPosition hit) {
            this.hit = hit;
            return this;
        }

        @Override
        public Builder block(Block block) {
            this.block = block;
            return this;
        }

        @Override
        public BlockAccessor.Builder itemForm(ItemStack itemStack) {
            this.itemForm = itemStack;
            return this;
        }

        @Override
        public Builder tileEntity(Supplier<TileEntity> tileEntity) {
            this.tileEntity = tileEntity;
            return this;
        }

        @Override
        public Builder meta(int metaData) {
            this.metadata = metaData;
            return this;
        }

        @Override
        public Builder requireVerification() {
            this.verify = true;
            return this;
        }

        @Override
        public BlockAccessor build() {
            BlockAccessorImpl accessor = new BlockAccessorImpl(this);
            if (this.verify) {
                accessor.requireVerification();
            }
            return accessor;
        }
    }
}

