/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.world.player;

import CoroUtil.config.ConfigCoroAI;
import CoroUtil.config.ConfigDynamicDifficulty;
import CoroUtil.entity.data.AttackData;
import CoroUtil.util.BlockCoord;
import CoroUtil.util.UtilPlayer;
import CoroUtil.world.WorldDirectorManager;
import CoroUtil.world.grid.chunk.ChunkDataPoint;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.oredict.OreDictionary;

public class DynamicDifficulty {
    public static String dataPlayerServerTicks = "HW_dataPlayerServerTicks";
    public static String dataPlayerLastCacheEquipmentRating = "HW_dataPlayerLastCacheEquipmentRating";
    public static String dataPlayerHarvestOre = "HW_dataPlayerHarvestOre";
    public static String dataPlayerHarvestLog = "HW_dataPlayerHarvestLog";
    public static String dataPlayerHarvestRating = "HW_dataPlayerHarvestRating";
    public static String dataPlayerDetectInAirTime = "HW_dataPlayerDetectInAirTime";
    private static int tickRate = 20;
    public static HashMap<Integer, AttackData> lookupEntToDamageLog = new HashMap();

    public static void tickServer(TickEvent.ServerTickEvent event) {
        WorldServer world = DimensionManager.getWorld((int)0);
        if (world != null) {
            long dayNumber;
            for (Object player : world.field_73010_i) {
                if (!(player instanceof EntityPlayer)) continue;
                DynamicDifficulty.tickPlayer((EntityPlayer)player);
            }
            if (ConfigCoroAI.cleanupStrayMobs && (dayNumber = world.func_72820_D() / 24000L + 1L) % (long)ConfigCoroAI.cleanupStrayMobsDayRate == 0L) {
                long timeOfDay = world.func_72820_D() % 24000L;
                int killTimeRange = 10;
                if (timeOfDay >= (long)ConfigCoroAI.cleanupStrayMobsTimeOfDay && timeOfDay < (long)(2000 + killTimeRange)) {
                    System.out.println("KILLING ALL ZOMBIES!");
                    for (Object obj : world.func_72910_y()) {
                        if (!(obj instanceof EntityZombie)) continue;
                        ((EntityZombie)obj).func_70106_y();
                    }
                }
            }
        }
    }

    public static void tickPlayer(EntityPlayer player) {
        World world = player.field_70170_p;
        if (world.func_82737_E() % (long)tickRate == 0L) {
            long ticksPlayed = player.getEntityData().func_74763_f(dataPlayerServerTicks);
            player.getEntityData().func_74772_a(dataPlayerServerTicks, ticksPlayed += 20L);
        }
        boolean autoAttackTest = true;
        boolean isInAir = false;
        boolean dbg = false;
        if (dbg) {
            System.out.println("player tick");
        }
        if (!player.field_71075_bZ.field_75098_d || autoAttackTest) {
            if (dbg) {
                System.out.println("1");
            }
            if (player.field_71075_bZ.field_75100_b || !player.field_70122_E && !player.func_70090_H() && !player.func_70055_a(Material.field_151587_i)) {
                if (dbg) {
                    System.out.println("2");
                }
                if (player.field_70154_o == null) {
                    if (dbg) {
                        System.out.println("3");
                    }
                    Block block = null;
                    int pX = MathHelper.func_76128_c((double)player.field_70165_t);
                    int pY = MathHelper.func_76128_c((double)player.field_70121_D.field_72338_b);
                    int pZ = MathHelper.func_76128_c((double)player.field_70161_v);
                    boolean foundWall = false;
                    for (int x = -1; !foundWall && x <= 1; ++x) {
                        block1: for (int z = -1; !foundWall && z <= 1; ++z) {
                            for (int y = -1; !foundWall && y <= 1; ++y) {
                                block = world.func_147439_a(pX + x, pY + y, pZ + z);
                                if (block == Blocks.field_150350_a) continue;
                                ArrayList list = new ArrayList();
                                block.func_149743_a(world, pX + x, pY + y, pZ + z, player.field_70121_D, list, (Entity)player);
                                if (list.size() <= 0) continue;
                                if (dbg) {
                                    System.out.println("wall found - " + block + " - " + (pX + x) + ", " + (pY + y) + ", " + (pZ + z));
                                }
                                foundWall = true;
                                continue block1;
                            }
                        }
                    }
                    if (!foundWall) {
                        if (dbg) {
                            System.out.println("no wall found");
                        }
                        isInAir = true;
                    }
                }
            }
        }
        if (isInAir) {
            if (dbg) {
                System.out.println("in air");
            }
            long airTime = player.getEntityData().func_74763_f(dataPlayerDetectInAirTime);
            player.getEntityData().func_74772_a(dataPlayerDetectInAirTime, airTime + 1L);
        } else {
            if (dbg) {
                System.out.println("not in air");
            }
            player.getEntityData().func_74772_a(dataPlayerDetectInAirTime, 0L);
        }
    }

    public static float getDifficultyScaleAverage(EntityPlayer player, int x, int y, int z) {
        return DynamicDifficulty.getDifficultyScaleAverage(player, new BlockCoord(x, y, z));
    }

    public static float getDifficultyScaleAverage(World world, EntityPlayer player, BlockCoord pos) {
        return DynamicDifficulty.getDifficultyScaleAverage(player, pos);
    }

    public static float getDifficultyScaleAverage(EntityPlayer player, BlockCoord pos) {
        World world = player.field_70170_p;
        float weightPosOccupy = (float)ConfigDynamicDifficulty.weightPosOccupy;
        float weightPlayerEquipment = (float)ConfigDynamicDifficulty.weightPlayerEquipment;
        float weightPlayerServerTime = (float)ConfigDynamicDifficulty.weightPlayerServerTime;
        float weightDPS = (float)ConfigDynamicDifficulty.weightDPS;
        float weightHealth = (float)ConfigDynamicDifficulty.weightHealth;
        float weightDistFromSpawn = (float)ConfigDynamicDifficulty.weightDistFromSpawn;
        float weightTotal = weightPosOccupy + weightPlayerEquipment + weightPlayerServerTime + weightDPS + weightDistFromSpawn;
        float difficultyPosOccupy = DynamicDifficulty.getDifficultyScaleForPosOccupyTime(world, pos) * weightPosOccupy;
        float difficultyPlayerEquipment = DynamicDifficulty.getDifficultyScaleForPlayerEquipment(player) * weightPlayerEquipment;
        float difficultyPlayerServerTime = DynamicDifficulty.getDifficultyScaleForPlayerServerTime(player) * weightPlayerServerTime;
        float difficultyDPS = DynamicDifficulty.getDifficultyScaleForPosDPS(world, pos) * weightDPS;
        float difficultyHealth = DynamicDifficulty.getDifficultyScaleForHealth(player) * weightHealth;
        float difficultyDistFromSpawn = DynamicDifficulty.getDifficultyScaleForDistFromSpawn(player) * weightDistFromSpawn;
        float difficultyTotal = difficultyPosOccupy + difficultyPlayerEquipment + difficultyPlayerServerTime + difficultyDPS + difficultyHealth + difficultyDistFromSpawn;
        float val = difficultyTotal / weightTotal;
        val = (float)Math.round(val * 1000.0f) / 1000.0f;
        if (ConfigDynamicDifficulty.difficulty_Max != -1.0 && (double)val > ConfigDynamicDifficulty.difficulty_Max) {
            val = (float)ConfigDynamicDifficulty.difficulty_Max;
        }
        return val;
    }

    public static float getDifficultyScaleForPlayerServerTime(EntityPlayer player) {
        long maxServerTime = ConfigDynamicDifficulty.difficulty_MaxTicksOnServer;
        long curServerTime = player.getEntityData().func_74763_f(dataPlayerServerTicks);
        return (float)Math.round(MathHelper.func_76131_a((float)((float)curServerTime / (float)maxServerTime), (float)0.0f, (float)1.0f) * 1000.0f) / 1000.0f;
    }

    public static float getDifficultyScaleForPlayerEquipment(EntityPlayer player) {
        boolean calcWeapon = false;
        int curRating = 0;
        if (player.getEntityData().func_74764_b(dataPlayerLastCacheEquipmentRating)) {
            if (player.field_70170_p.func_82737_E() % 200L == 0L) {
                curRating = UtilPlayer.getPlayerRating(player, calcWeapon);
                player.getEntityData().func_74768_a(dataPlayerLastCacheEquipmentRating, curRating);
            } else {
                curRating = player.getEntityData().func_74762_e(dataPlayerLastCacheEquipmentRating);
            }
        } else {
            curRating = UtilPlayer.getPlayerRating(player, calcWeapon);
            player.getEntityData().func_74768_a(dataPlayerLastCacheEquipmentRating, curRating);
        }
        int bestRating = DynamicDifficulty.getBestPlayerRatingPossibleVanilla(calcWeapon);
        return (float)curRating / (float)bestRating;
    }

    public static float getDifficultyScaleForHealth(EntityPlayer player) {
        float baseMax = 20.0f;
        float curMax = player.func_110138_aP();
        float scale = curMax / baseMax;
        return scale - 1.0f;
    }

    public static float getDifficultyScaleForDistFromSpawn(EntityPlayer player) {
        float distX = (float)((double)player.field_70170_p.func_72861_E().field_71574_a - player.field_70165_t);
        float distZ = (float)((double)player.field_70170_p.func_72861_E().field_71573_c - player.field_70161_v);
        float dist = (float)Math.sqrt(distX * distX + distZ * distZ);
        dist = Math.min(dist, (float)ConfigDynamicDifficulty.difficulty_DistFromSpawnMax);
        return dist / (float)ConfigDynamicDifficulty.difficulty_DistFromSpawnMax;
    }

    public static int getBestPlayerRatingPossibleVanilla(boolean calcWeapon) {
        int bestArmor = 20;
        int bestArmorEnchant = 25;
        int bestWeapon = 8;
        int bestWeaponEnchant = 6;
        if (!calcWeapon) {
            bestWeapon = 0;
            bestWeaponEnchant = 0;
        }
        int bestVal = bestArmor + bestArmorEnchant + bestWeapon + bestWeaponEnchant;
        return bestVal;
    }

    public static float getBestPlayerDPSRatingPossibleVanilla() {
        return ConfigDynamicDifficulty.difficulty_BestVanillaDPS;
    }

    public static float getDifficultyScaleForPosDPS(World world, BlockCoord pos) {
        int chunkRange = ConfigDynamicDifficulty.difficulty_BestDPSRadius;
        int chunkX = pos.getX() / 16;
        int chunkZ = pos.getZ() / 16;
        float bestDPS = 0.0f;
        for (int x = chunkX - chunkRange; x < chunkX + chunkRange; ++x) {
            for (int z = chunkZ - chunkRange; z < chunkZ + chunkRange; ++z) {
                Chunk chunk;
                BlockCoord checkPos = new BlockCoord(x * 16 + 8, 128, z * 16 + 8);
                if (!world.func_72904_c(checkPos.field_71574_a, checkPos.field_71572_b, checkPos.field_71573_c, checkPos.field_71574_a, checkPos.field_71572_b, checkPos.field_71573_c) || (chunk = world.func_72938_d(checkPos.field_71574_a, checkPos.field_71573_c)) == null) continue;
                ChunkDataPoint cdp = WorldDirectorManager.instance().getChunkDataGrid(world).getChunkData(x, z);
                if (!(cdp.averageDPS > bestDPS)) continue;
                bestDPS = cdp.averageDPS;
            }
        }
        float scale = DynamicDifficulty.convertDPSToDifficultyScale(bestDPS);
        return scale;
    }

    public static float convertDPSToDifficultyScale(float dps) {
        float scale = dps / DynamicDifficulty.getBestPlayerDPSRatingPossibleVanilla();
        if ((double)scale > ConfigDynamicDifficulty.difficulty_MaxDPSRatingAllowed) {
            scale = (float)ConfigDynamicDifficulty.difficulty_MaxDPSRatingAllowed;
        }
        return scale;
    }

    public static float getDifficultyScaleForPosOccupyTime(World world, BlockCoord pos) {
        int chunkRange = 3;
        int chunkX = pos.getX() / 16;
        int chunkZ = pos.getZ() / 16;
        int count = 0;
        long totalTime = 0L;
        for (int x = chunkX - chunkRange; x < chunkX + chunkRange; ++x) {
            for (int z = chunkZ - chunkRange; z < chunkZ + chunkRange; ++z) {
                Chunk chunk;
                BlockCoord checkPos = new BlockCoord(x * 16 + 8, 128, z * 16 + 8);
                if (!world.func_72904_c(checkPos.field_71574_a, checkPos.field_71572_b, checkPos.field_71573_c, checkPos.field_71574_a, checkPos.field_71572_b, checkPos.field_71573_c) || (chunk = world.func_72938_d(checkPos.field_71574_a, checkPos.field_71573_c)) == null) continue;
                totalTime += chunk.field_111204_q;
                ++count;
            }
        }
        long averageTime = 0L;
        if (count > 0) {
            averageTime = totalTime / (long)count;
        }
        float scale = DynamicDifficulty.convertInhabTimeToDifficultyScale(averageTime);
        return (float)Math.round(scale * 1000.0f) / 1000.0f;
    }

    public static float convertInhabTimeToDifficultyScale(long inhabTime) {
        float scale = (float)inhabTime / (float)ConfigDynamicDifficulty.difficulty_MaxTicksInChunk;
        return scale;
    }

    public static void handleHarvest(BlockEvent.HarvestDropsEvent event) {
        if (event.harvester != null && event.world.field_73010_i.contains(event.harvester)) {
            NBTTagCompound nbt = event.harvester.getEntityData();
            if (event.block instanceof BlockOre) {
                int curVal = nbt.func_74762_e(dataPlayerHarvestOre);
                nbt.func_74768_a(dataPlayerHarvestOre, ++curVal);
            } else if (event.block instanceof BlockLog) {
                int curVal = nbt.func_74762_e(dataPlayerHarvestLog);
                nbt.func_74768_a(dataPlayerHarvestLog, ++curVal);
            }
            DynamicDifficulty.increaseInvadeRating(event.harvester, DynamicDifficulty.getBlockImportanceValue(event.block));
        }
    }

    public static void increaseInvadeRating(EntityPlayer parPlayer, float parVal) {
        NBTTagCompound nbt = parPlayer.getEntityData();
        float curVal = nbt.func_74760_g(dataPlayerHarvestRating);
        nbt.func_74776_a(dataPlayerHarvestRating, curVal += parVal);
    }

    public static void decreaseInvadeRating(EntityPlayer parPlayer, float parVal) {
        NBTTagCompound nbt = parPlayer.getEntityData();
        float curVal = nbt.func_74760_g(dataPlayerHarvestRating);
        nbt.func_74776_a(dataPlayerHarvestRating, curVal -= parVal);
    }

    public static float getHarvestRatingInvadeThreshold() {
        return 30.0f;
    }

    public static boolean isInvadeable(EntityPlayer parPlayer) {
        return parPlayer.getEntityData().func_74760_g(dataPlayerHarvestRating) >= DynamicDifficulty.getHarvestRatingInvadeThreshold();
    }

    public static float getBlockImportanceValue(Block block) {
        boolean test = false;
        if (test) {
            System.out.println("TEST INVADE IS ON!");
            return 30.0f;
        }
        float scaleBase = 1.0f;
        float defaultIron = scaleBase * 0.3f;
        if (block instanceof BlockLog) {
            return scaleBase * 0.1f;
        }
        if (block instanceof BlockSapling) {
            return scaleBase * 0.3f;
        }
        if (block instanceof BlockOre) {
            if (block == Blocks.field_150365_q) {
                return scaleBase * 0.2f;
            }
            if (block == Blocks.field_150366_p) {
                return defaultIron;
            }
            if (block == Blocks.field_150352_o) {
                return scaleBase * 0.4f;
            }
            if (block == Blocks.field_150439_ay || block == Blocks.field_150450_ax) {
                return scaleBase * 0.5f;
            }
            if (block == Blocks.field_150369_x) {
                return scaleBase * 0.6f;
            }
            if (block == Blocks.field_150482_ag) {
                return scaleBase * 1.0f;
            }
            if (block == Blocks.field_150412_bA) {
                return scaleBase * 1.2f;
            }
            return defaultIron;
        }
        if (OreDictionary.getOres((String)Block.field_149771_c.func_148750_c((Object)block)).size() > 0) {
            return defaultIron;
        }
        return 0.0f;
    }

    public static EntityPlayer getBestPlayerForArea(World world, BlockCoord pos) {
        EntityPlayer player = world.func_72977_a((double)pos.field_71574_a, (double)pos.field_71572_b, (double)pos.field_71573_c, -1.0);
        return player;
    }

    public static void logDamage(LivingHurtEvent event) {
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (ConfigDynamicDifficulty.trackChunkData) {
            Entity ent = event.entity;
            World world = ent.field_70170_p;
            if (ent instanceof IMob && ent instanceof EntityCreature) {
                EntityCreature entC = (EntityCreature)ent;
                if (event.source == DamageSource.field_76368_d || event.source == DamageSource.field_76372_a || event.source == DamageSource.field_76370_b || event.source == DamageSource.field_76369_e) {
                    return;
                }
                AttackData log = null;
                if (!lookupEntToDamageLog.containsKey(ent.func_145782_y())) {
                    log = new AttackData(entC);
                    lookupEntToDamageLog.put(ent.func_145782_y(), log);
                } else {
                    int lastLogTimeThreshold = 100;
                    log = lookupEntToDamageLog.get(ent.func_145782_y());
                    if (log.getLastLogTime() + (long)lastLogTimeThreshold < world.func_82737_E()) {
                        DynamicDifficulty.logToChunk(log);
                        log.cleanup();
                        log = new AttackData(entC);
                        lookupEntToDamageLog.put(ent.func_145782_y(), log);
                    }
                }
                float damageToLog = event.ammount;
                if (log.getLastDamage() > 0.0f) {
                    long timeDiff = world.func_82737_E() - log.getLastLogTime();
                    float timeDiffSeconds = (float)timeDiff / 20.0f;
                    if (timeDiff > 0L) {
                        float damage = log.getLastDamage() / timeDiffSeconds;
                        if (ConfigDynamicDifficulty.difficulty_MaxDPSLoggable != -1.0 && (double)damage > ConfigDynamicDifficulty.difficulty_MaxDPSLoggable) {
                            damage = (float)ConfigDynamicDifficulty.difficulty_MaxDPSLoggable;
                        }
                        log.getListDPSs().add(Float.valueOf(damage));
                    } else {
                        damageToLog += log.getLastDamage();
                    }
                }
                log.setLastDamage(damageToLog);
                log.setLastLogTime(world.func_82737_E());
            }
        }
    }

    public static void logDeath(LivingDeathEvent event) {
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (ConfigDynamicDifficulty.trackChunkData) {
            Entity ent = event.entity;
            World world = ent.field_70170_p;
            if (ent instanceof IMob && ent instanceof EntityCreature && lookupEntToDamageLog.containsKey(ent.func_145782_y())) {
                AttackData log = lookupEntToDamageLog.get(ent.func_145782_y());
                DynamicDifficulty.logToChunk(log);
                log.cleanup();
                lookupEntToDamageLog.remove(ent.func_145782_y());
            }
        }
    }

    public static void logToChunk(AttackData log) {
        int maxShortTermSize = 50;
        int maxLongTermSize = 50;
        int recalcRate = 40;
        EntityCreature ent = log.getEnt();
        World world = ent.field_70170_p;
        int chunkX = MathHelper.func_76128_c((double)(ent.field_70165_t / 16.0));
        int chunkZ = MathHelper.func_76128_c((double)(ent.field_70161_v / 16.0));
        ChunkDataPoint cdp = WorldDirectorManager.instance().getChunkDataGrid(world).getChunkData(chunkX, chunkZ);
        if (log.getListDPSs().size() == 0 && log.getLastDamage() > 0.0f) {
            float instaKillDPSCalc = log.getLastDamage() * 2.0f;
            if (ConfigDynamicDifficulty.difficulty_MaxDPSLoggable != -1.0 && (double)instaKillDPSCalc > ConfigDynamicDifficulty.difficulty_MaxDPSLoggable) {
                instaKillDPSCalc = (float)ConfigDynamicDifficulty.difficulty_MaxDPSLoggable;
            }
            log.getListDPSs().add(Float.valueOf(instaKillDPSCalc));
        }
        if (log.getListDPSs().size() > 0) {
            float avgDPS = 0.0f;
            for (float val : log.getListDPSs()) {
                avgDPS += val;
            }
            cdp.listDPSAveragesShortTerm.add(Float.valueOf(avgDPS /= (float)log.getListDPSs().size()));
        }
        if (cdp.listDPSAveragesShortTerm.size() > maxShortTermSize) {
            cdp.listDPSAveragesShortTerm.remove(0);
        }
        if (cdp.lastDPSRecalc + (long)recalcRate < world.func_82737_E()) {
            if (cdp.listDPSAveragesShortTerm.size() > 0) {
                float avgDPS2 = 0.0f;
                for (float val : cdp.listDPSAveragesShortTerm) {
                    avgDPS2 += val;
                }
                cdp.listDPSAveragesLongTerm.add(Float.valueOf(avgDPS2 /= (float)cdp.listDPSAveragesShortTerm.size()));
            }
            if (cdp.listDPSAveragesLongTerm.size() > maxLongTermSize) {
                cdp.listDPSAveragesLongTerm.remove(0);
            }
            if (cdp.listDPSAveragesLongTerm.size() > 0) {
                float avgDPS3 = 0.0f;
                for (float val : cdp.listDPSAveragesLongTerm) {
                    avgDPS3 += val;
                }
                cdp.averageDPS = avgDPS3 /= (float)cdp.listDPSAveragesLongTerm.size();
            }
            cdp.lastDPSRecalc = world.func_82737_E();
        }
    }
}

