/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.world.location;

import CoroUtil.util.ChunkCoordinatesBlock;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.CoroUtilNBT;
import CoroUtil.world.location.ManagedLocation;
import build.ICustomGen;
import build.world.BuildJob;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class StructureObject
implements ICustomGen {
    public long ID = 0L;
    public ManagedLocation location;
    public String name = "";
    public int dimID;
    public int locationID = -1;
    public boolean isBuilt = false;
    public ChunkCoordinates pos;
    public boolean callbackNeedsFirstTimeInit = false;
    public NBTTagCompound initNBTTileEntity = new NBTTagCompound();

    public StructureObject() {
        this.pos = new ChunkCoordinates();
    }

    public void dbg(Object obj) {
        System.out.println("RTSDBG " + this.name + ": " + obj);
    }

    public void init() {
        if (!this.isBuilt) {
            this.buildStructureComplete(true);
            this.isBuilt = true;
        }
    }

    public void tickUpdate() {
    }

    public void writeToNBT(NBTTagCompound var1) {
        var1.func_74772_a("ID", this.ID);
        var1.func_74778_a("name", this.name);
        var1.func_74768_a("teamID", this.locationID);
        var1.func_74757_a("isBuilt", this.isBuilt);
        CoroUtilNBT.writeCoords("pos", this.pos, var1);
    }

    public void readFromNBT(NBTTagCompound var1) {
        if (var1.func_74764_b("ID")) {
            this.ID = var1.func_74763_f("ID");
        }
        if (var1.func_74764_b("name")) {
            this.name = var1.func_74779_i("name");
        }
        if (var1.func_74764_b("teamID")) {
            this.locationID = var1.func_74762_e("teamID");
        }
        this.isBuilt = var1.func_74767_n("isBuilt");
        this.pos = CoroUtilNBT.readCoords("pos", var1);
    }

    public List<ChunkCoordinatesBlock> getStructureGenerationComplete(boolean firstTimeScan) {
        List<ChunkCoordinatesBlock> dataTotal = new ArrayList<ChunkCoordinatesBlock>();
        ArrayList<Integer> redundancyData = new ArrayList<Integer>();
        dataTotal = this.getStructureGenerationPattern(dataTotal, redundancyData, firstTimeScan);
        dataTotal = this.getStructureGenerationSchematic(dataTotal, redundancyData, firstTimeScan);
        return dataTotal;
    }

    public List<ChunkCoordinatesBlock> getStructureGenerationPattern(List<ChunkCoordinatesBlock> parData, List<Integer> redundancyData, boolean firstTimeScan) {
        return parData;
    }

    public List<ChunkCoordinatesBlock> getStructureGenerationSchematic(List<ChunkCoordinatesBlock> parData, List<Integer> redundancyData, boolean firstTimeScan) {
        return parData;
    }

    public void updateStructureState(List<ChunkCoordinatesBlock> parStructure, boolean firstTimeGen) {
    }

    public void buildStructureComplete(boolean firstTimeGen) {
        this.updateInitNBTForTileEntities();
        List<ChunkCoordinatesBlock> data = this.getStructureGenerationPattern(new ArrayList<ChunkCoordinatesBlock>(), new ArrayList<Integer>(), firstTimeGen);
        this.buildPattern(data);
        if (!this.buildSchematic()) {
            this.updateStructureState(data, firstTimeGen);
            this.buildingCompleted(firstTimeGen);
        } else {
            this.callbackNeedsFirstTimeInit = firstTimeGen;
        }
    }

    @Override
    public void genPassPre(World world, BuildJob parBuildJob, int parPass) {
        if (parPass == -1) {
            System.out.println("building gen complete, calculating cur and max health");
            List<ChunkCoordinatesBlock> data = this.getStructureGenerationComplete(false);
            this.updateStructureState(data, this.callbackNeedsFirstTimeInit);
            this.buildingCompleted(this.callbackNeedsFirstTimeInit);
        }
    }

    public void buildingCompleted(boolean firstTimeGen) {
    }

    public void updateInitNBTForTileEntities() {
        this.initNBTTileEntity.func_74768_a("teamID", this.locationID);
        this.initNBTTileEntity.func_74772_a("structureID", this.ID);
    }

    public boolean buildSchematic() {
        return false;
    }

    public void buildPattern(List<ChunkCoordinatesBlock> parStructure) {
        WorldServer world = DimensionManager.getWorld((int)this.location.dimID);
        if (world != null) {
            for (int i = 0; i < parStructure.size(); ++i) {
                ChunkCoordinatesBlock coords = parStructure.get(i);
                world.func_147465_d(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, coords.block, coords.meta, 3);
            }
        }
    }

    public ChunkCoordinates getBuildingCornerCoord() {
        return null;
    }

    public boolean isSafeToGenerateOver(Block id) {
        return CoroUtilBlock.isAir(id) || id == Blocks.field_150329_H || id == Blocks.field_150433_aE;
    }

    public boolean isRequiredGroundBlock(Block id) {
        return id == Blocks.field_150355_j || id == Blocks.field_150358_i || id == Blocks.field_150349_c || id == Blocks.field_150346_d || id == Blocks.field_150354_m || id == Blocks.field_150348_b || id == Blocks.field_150351_n;
    }

    public boolean isLogOrLeafBlock(Block block) {
        if (block == null) {
            return false;
        }
        if (block.func_149688_o() == Material.field_151584_j) {
            return true;
        }
        if (block.func_149688_o() == Material.field_151585_k) {
            return true;
        }
        return block.func_149688_o() == Material.field_151575_d;
    }

    public int getTopGroundBlock(World world, int x, int startY, int z) {
        int safetyCount = 0;
        for (int curY = startY; curY > 0 && safetyCount++ < 300; --curY) {
            Block id = world.func_147439_a(x, curY, z);
            if (!this.isRequiredGroundBlock(id)) continue;
            return curY;
        }
        return 1;
    }

    @Override
    public NBTTagCompound getInitNBTTileEntity() {
        return this.initNBTTileEntity;
    }
}

