/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.music;

import CoroUtil.music.Melody;
import CoroUtil.music.NoteHelper;
import java.util.ArrayList;
import java.util.List;

public class Sequencer
implements Runnable {
    public boolean running = false;
    public int tempo = 120;
    public int ticksPlaying = 0;
    public int beatsPlaying = 0;
    public List<Melody> listMelodies = new ArrayList<Melody>();

    @Override
    public void run() {
        while (this.running) {
            try {
                this.tickIterate();
                float delayMilli = 60000 / (this.tempo * NoteHelper.CONV_BEAT_TO_FASTEST_NOTE);
                int delayNano = (int)((delayMilli - (float)((int)delayMilli)) * 1000000.0f);
                Thread.sleep((int)delayMilli, delayNano);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void tickIterate() {
        for (int i = 0; i < this.listMelodies.size(); ++i) {
            Melody mel = this.listMelodies.get(i);
            mel.tick();
        }
        ++this.ticksPlaying;
        if (this.ticksPlaying % NoteHelper.CONV_BEAT_TO_FASTEST_NOTE == 0) {
            ++this.beatsPlaying;
        }
    }

    public synchronized void start() {
        this.running = true;
    }

    public synchronized void stop() {
        this.running = false;
        for (int i = 0; i < this.listMelodies.size(); ++i) {
            Melody mel = this.listMelodies.get(i);
            mel.stop();
        }
    }
}

