/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.patching;

import com.falsepattern.endlessids.EndlessIDs;
import com.falsepattern.endlessids.patching.Patch;
import com.falsepattern.endlessids.patching.patches.common.Futurepack;
import com.falsepattern.endlessids.patching.patches.common.Tropicraft;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.List;

public class CommonManager {
    protected final List<Patch> patches = new ArrayList<Patch>();

    public CommonManager() {
        this.patches.add(new Tropicraft());
        this.patches.add(new Futurepack());
    }

    public final void construct() {
        this.runPatches("construct", Patch::construct);
    }

    public final void preInit() {
        this.runPatches("preInit", Patch::preInit);
    }

    public final void init() {
        this.runPatches("init", Patch::init);
    }

    public final void postInit() {
        this.runPatches("postInit", Patch::postInit);
    }

    private void runPatches(String stageName, Stage stage) throws Exception {
        for (Patch patch : this.patches) {
            if (!Loader.isModLoaded((String)patch.modid)) continue;
            try {
                if (!stage.run(patch)) continue;
                EndlessIDs.LOG.info("Applied patch " + patch.getClass().getSimpleName() + " stage " + stageName + " for " + patch.modid);
            }
            catch (Exception e) {
                EndlessIDs.LOG.fatal("Failed to apply patch " + patch.getClass().getSimpleName() + " stage " + stageName + " for " + patch.modid);
                throw e;
            }
        }
    }

    public static interface Stage {
        public boolean run(Patch var1) throws Exception;
    }
}

