/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.mixin.mixins.common.blockitem.vanilla;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Block.class})
public abstract class BlockMixin {
    @Unique
    private String eid$defaultHarvestTool = null;
    @Unique
    private int eid$defaultHarvestLevel = -1;
    @Unique
    private final Int2ObjectOpenHashMap<String> eid$harvestToolMap = new Int2ObjectOpenHashMap();
    @Unique
    private final Int2IntOpenHashMap eid$harvestLevelMap = new Int2IntOpenHashMap();
    @Shadow(remap=false)
    private String[] harvestTool = null;
    @Shadow(remap=false)
    private int[] harvestLevel = null;

    @Overwrite(remap=false)
    public void setHarvestLevel(String toolClass, int level) {
        this.eid$defaultHarvestTool = toolClass;
        this.eid$defaultHarvestLevel = level;
        this.eid$harvestToolMap.clear();
        this.eid$harvestLevelMap.clear();
    }

    @Overwrite(remap=false)
    public void setHarvestLevel(String toolClass, int level, int metadata) {
        this.eid$harvestToolMap.put(metadata, (Object)toolClass);
        this.eid$harvestLevelMap.put(metadata, level);
    }

    @Overwrite(remap=false)
    public String getHarvestTool(int metadata) {
        return (String)this.eid$harvestToolMap.getOrDefault(metadata, (Object)this.eid$defaultHarvestTool);
    }

    @Overwrite(remap=false)
    public int getHarvestLevel(int metadata) {
        return this.eid$harvestLevelMap.getOrDefault(metadata, this.eid$defaultHarvestLevel);
    }

    @Overwrite(remap=false)
    public boolean isToolEffective(String type, int metadata) {
        Block self = (Block)this;
        if ("pickaxe".equals(type) && (self == Blocks.field_150450_ax || self == Blocks.field_150439_ay || self == Blocks.field_150343_Z)) {
            return false;
        }
        String harvestTool = this.getHarvestTool(metadata);
        if (harvestTool == null) {
            return false;
        }
        return harvestTool.equals(type);
    }
}

