/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.mixin.mixins.common.biome.vanilla;

import com.falsepattern.endlessids.EndlessIDs;
import com.falsepattern.endlessids.mixin.helpers.ChunkBiomeHook;
import java.util.Arrays;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Chunk.class}, priority=900)
public abstract class ChunkMixin
implements ChunkBiomeHook {
    @Shadow
    @Final
    public int field_76635_g;
    @Shadow
    @Final
    public int field_76647_h;
    @Shadow
    public World field_76637_e;
    @Shadow
    private byte[] field_76651_r;
    @Unique
    private short[] eid$blockBiomeShortArray;

    @Inject(method={"<init>(Lnet/minecraft/world/World;II)V"}, at={@At(value="RETURN")}, require=1)
    private void initShortArray(World p_i1995_1_, int p_i1995_2_, int p_i1995_3_, CallbackInfo ci) {
        this.field_76651_r = null;
        this.eid$blockBiomeShortArray = new short[256];
        Arrays.fill(this.eid$blockBiomeShortArray, (short)-1);
    }

    @Unique
    private void eid$emergencyCrash() {
        String crashMSG = "A mod that is incompatible with EndlessIDs has tried to access the biome array of a chunk like in vanilla! Crashing in fear of potential world corruption!\nPlease report this issue on https://github.com/GTMEGA/EndlessIDs ASAP!";
        EndlessIDs.LOG.fatal("A mod that is incompatible with EndlessIDs has tried to access the biome array of a chunk like in vanilla! Crashing in fear of potential world corruption!\nPlease report this issue on https://github.com/GTMEGA/EndlessIDs ASAP!");
        throw new UnsupportedOperationException("A mod that is incompatible with EndlessIDs has tried to access the biome array of a chunk like in vanilla! Crashing in fear of potential world corruption!\nPlease report this issue on https://github.com/GTMEGA/EndlessIDs ASAP!");
    }

    @Inject(method={"setBiomeArray"}, at={@At(value="HEAD")}, require=1)
    private void crashSetBiomeArray(byte[] p_76616_1_, CallbackInfo ci) {
        this.eid$emergencyCrash();
    }

    @Inject(method={"getBiomeArray"}, at={@At(value="HEAD")}, require=1)
    private void crashGetBiomeArray(CallbackInfoReturnable<byte[]> cir) {
        this.eid$emergencyCrash();
    }

    @Overwrite
    public BiomeGenBase func_76591_a(int x, int z, WorldChunkManager manager) {
        int id = this.eid$blockBiomeShortArray[z << 4 | x] & 0xFFFF;
        if (id == 65535) {
            if (this.field_76637_e.field_72995_K) {
                return BiomeGenBase.field_76771_b;
            }
            BiomeGenBase gen = manager.func_76935_a((this.field_76635_g << 4) + x, (this.field_76647_h << 4) + z);
            id = gen.field_76756_M;
            this.eid$blockBiomeShortArray[z << 4 | x] = (short)(id & 0xFFFF);
        }
        return BiomeGenBase.func_150568_d((int)id) == null ? BiomeGenBase.field_76772_c : BiomeGenBase.func_150568_d((int)id);
    }

    @Override
    public short[] getBiomeShortArray() {
        return this.eid$blockBiomeShortArray;
    }

    @Override
    public void setBiomeShortArray(short[] data) {
        this.eid$blockBiomeShortArray = data;
    }
}

