/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.mixin.helpers;

import com.falsepattern.endlessids.Hooks;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import lotr.common.LOTRDimension;
import lotr.common.network.LOTRPacketBiomeVariantsUnwatch;
import lotr.common.network.LOTRPacketBiomeVariantsWatch;
import lotr.common.network.LOTRPacketHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class LOTRBiomeVariantStorageShort {
    private static final Map<LOTRDimension, Map<ChunkCoordIntPair, short[]>> chunkVariantMap = new HashMap<LOTRDimension, Map<ChunkCoordIntPair, short[]>>();
    private static final Map<LOTRDimension, Map<ChunkCoordIntPair, short[]>> chunkVariantMapClient = new HashMap<LOTRDimension, Map<ChunkCoordIntPair, short[]>>();

    private static Map<ChunkCoordIntPair, short[]> getDimensionChunkMap(World world) {
        Map<LOTRDimension, Map<ChunkCoordIntPair, short[]>> sourcemap = !world.field_72995_K ? chunkVariantMap : chunkVariantMapClient;
        LOTRDimension dim = LOTRDimension.getCurrentDimensionWithFallback((World)world);
        return sourcemap.computeIfAbsent(dim, k -> new HashMap());
    }

    private static ChunkCoordIntPair getChunkKey(Chunk chunk) {
        return new ChunkCoordIntPair(chunk.field_76635_g, chunk.field_76647_h);
    }

    public static short[] getChunkBiomeVariants(World world, Chunk chunk) {
        return LOTRBiomeVariantStorageShort.getChunkBiomeVariants(world, LOTRBiomeVariantStorageShort.getChunkKey(chunk));
    }

    public static short[] getChunkBiomeVariants(World world, ChunkCoordIntPair chunk) {
        return LOTRBiomeVariantStorageShort.getDimensionChunkMap(world).get(chunk);
    }

    public static void setChunkBiomeVariants(World world, Chunk chunk, short[] variants) {
        LOTRBiomeVariantStorageShort.setChunkBiomeVariants(world, LOTRBiomeVariantStorageShort.getChunkKey(chunk), variants);
    }

    public static void setChunkBiomeVariants(World world, ChunkCoordIntPair chunk, short[] variants) {
        LOTRBiomeVariantStorageShort.getDimensionChunkMap(world).put(chunk, variants);
    }

    public static void clearChunkBiomeVariants(World world, Chunk chunk) {
        LOTRBiomeVariantStorageShort.clearChunkBiomeVariants(world, LOTRBiomeVariantStorageShort.getChunkKey(chunk));
    }

    public static void clearChunkBiomeVariants(World world, ChunkCoordIntPair chunk) {
        LOTRBiomeVariantStorageShort.getDimensionChunkMap(world).remove(chunk);
    }

    public static void loadChunkVariants(World world, Chunk chunk, NBTTagCompound data) {
        if (LOTRBiomeVariantStorageShort.getChunkBiomeVariants(world, chunk) == null) {
            short[] variants = data.func_74764_b("LOTRBiomeVariantsS") ? Hooks.byteToShortArray(data.func_74770_j("LOTRBiomeVariantsS")) : new short[256];
            LOTRBiomeVariantStorageShort.setChunkBiomeVariants(world, chunk, variants);
        }
    }

    public static void saveChunkVariants(World world, Chunk chunk, NBTTagCompound data) {
        short[] variants = LOTRBiomeVariantStorageShort.getChunkBiomeVariants(world, chunk);
        if (variants != null) {
            data.func_74773_a("LOTRBiomeVariantsS", Hooks.shortToByteArray(variants));
        }
    }

    public static void clearAllVariants(World world) {
        LOTRBiomeVariantStorageShort.getDimensionChunkMap(world).clear();
        FMLLog.info((String)"Unloading LOTR biome variants in %s", (Object[])new Object[]{LOTRDimension.getCurrentDimensionWithFallback((World)world).dimensionName});
    }

    public static void performCleanup(WorldServer world) {
        Map<ChunkCoordIntPair, short[]> dimensionMap = LOTRBiomeVariantStorageShort.getDimensionChunkMap((World)world);
        ArrayList<ChunkCoordIntPair> removalChunks = new ArrayList<ChunkCoordIntPair>();
        for (ChunkCoordIntPair chunk : dimensionMap.keySet()) {
            if (world.field_73059_b.func_73149_a(chunk.field_77276_a, chunk.field_77275_b)) continue;
            removalChunks.add(chunk);
        }
        for (ChunkCoordIntPair chunk : removalChunks) {
            dimensionMap.remove(chunk);
        }
    }

    public static void sendChunkVariantsToPlayer(World world, Chunk chunk, EntityPlayerMP entityplayer) {
        short[] variants = LOTRBiomeVariantStorageShort.getChunkBiomeVariants(world, chunk);
        if (variants != null) {
            LOTRPacketBiomeVariantsWatch packet = new LOTRPacketBiomeVariantsWatch(chunk.field_76635_g, chunk.field_76647_h, Hooks.shortToByteArray(variants));
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, entityplayer);
        } else {
            String dimName = world.field_73011_w.func_80007_l();
            int posX = chunk.field_76635_g << 4;
            int posZ = chunk.field_76647_h << 4;
            String playerName = entityplayer.func_70005_c_();
            FMLLog.severe((String)"Could not find LOTR biome variants for %s chunk at %d, %d; requested by %s", (Object[])new Object[]{dimName, posX, posZ, playerName});
        }
    }

    public static void sendUnwatchToPlayer(World world, Chunk chunk, EntityPlayerMP entityplayer) {
        LOTRPacketBiomeVariantsUnwatch packet = new LOTRPacketBiomeVariantsUnwatch(chunk.field_76635_g, chunk.field_76647_h);
        LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, entityplayer);
    }

    public static int getSize(World world) {
        Map<ChunkCoordIntPair, short[]> map = LOTRBiomeVariantStorageShort.getDimensionChunkMap(world);
        return map.size();
    }

    @Generated
    private LOTRBiomeVariantStorageShort() {
    }
}

