/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.managers;

import com.falsepattern.chunk.api.ArrayUtil;
import com.falsepattern.chunk.api.DataManager;
import com.falsepattern.endlessids.mixin.helpers.SubChunkBlockHook;
import com.falsepattern.endlessids.util.DataUtil;
import java.nio.ByteBuffer;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockIDManager
implements DataManager.PacketDataManager,
DataManager.SubChunkDataManager,
DataManager.BlockPacketDataManager {
    public String domain() {
        return "endlessids";
    }

    public String id() {
        return "blockid";
    }

    public int maxPacketSize() {
        return 196612;
    }

    public void writeToBuffer(Chunk chunk, int subChunkMask, boolean forceUpdate, ByteBuffer data) {
        ExtendedBlockStorage[] subChunkList = chunk.func_76587_i();
        int storageFlags = 0;
        int start = data.position() + 4;
        data.position(start);
        for (int i = 0; i < 16; ++i) {
            if ((subChunkMask & 1 << i) == 0 || subChunkList[i] == null) continue;
            SubChunkBlockHook subChunk = (SubChunkBlockHook)subChunkList[i];
            storageFlags |= subChunk.eid$getBlockMask() << i * 2;
            byte[] b1 = subChunk.eid$getB1();
            data.put(b1);
            NibbleArray b2Low = subChunk.eid$getB2Low();
            if (b2Low == null) continue;
            data.put(b2Low.field_76585_a);
            NibbleArray b2High = subChunk.eid$getB2High();
            if (b2High == null) continue;
            data.put(b2High.field_76585_a);
            byte[] b3 = subChunk.eid$getB3();
            if (b3 == null) continue;
            data.put(b3);
        }
        data.putInt(start - 4, storageFlags);
    }

    public void readFromBuffer(Chunk chunk, int subChunkMask, boolean forceUpdate, ByteBuffer buffer) {
        ExtendedBlockStorage[] subChunkList = chunk.func_76587_i();
        int storageFlags = buffer.getInt();
        for (int i = 0; i < 16; ++i) {
            if ((subChunkMask & 1 << i) == 0 || subChunkList[i] == null) continue;
            SubChunkBlockHook subChunk = (SubChunkBlockHook)subChunkList[i];
            int storageFlag = storageFlags >>> i * 2 & 3;
            byte[] b1 = subChunk.eid$getB1();
            buffer.get(b1);
            if (storageFlag == 0) {
                subChunk.eid$setB2Low(null);
                subChunk.eid$setB2High(null);
                subChunk.eid$setB3(null);
                continue;
            }
            NibbleArray b2Low = subChunk.eid$getB2Low();
            if (b2Low == null) {
                b2Low = subChunk.eid$createB2Low();
            }
            buffer.get(b2Low.field_76585_a);
            if (storageFlag == 1) {
                subChunk.eid$setB2High(null);
                subChunk.eid$setB3(null);
                continue;
            }
            NibbleArray b2High = subChunk.eid$getB2High();
            if (b2High == null) {
                b2High = subChunk.eid$createB2High();
            }
            buffer.get(b2High.field_76585_a);
            if (storageFlag == 2) {
                subChunk.eid$setB3(null);
                continue;
            }
            byte[] b3 = subChunk.eid$getB3();
            if (b3 == null) {
                b3 = subChunk.eid$createB3();
            }
            buffer.get(b3);
        }
    }

    public boolean subChunkPrivilegedAccess() {
        return true;
    }

    public void writeSubChunkToNBT(Chunk chunk, ExtendedBlockStorage subChunkVanilla, NBTTagCompound nbt) {
        SubChunkBlockHook subChunk = (SubChunkBlockHook)subChunkVanilla;
        byte[] b1 = subChunk.eid$getB1();
        NibbleArray b2Low = subChunk.eid$getB2Low();
        NibbleArray b2High = subChunk.eid$getB2High();
        byte[] b3 = subChunk.eid$getB3();
        nbt.func_74773_a("Blocks", b1);
        if (b2Low != null) {
            nbt.func_74773_a("Add", b2Low.field_76585_a);
        }
        if (b2High != null) {
            nbt.func_74773_a("BlocksB2Hi", b2High.field_76585_a);
        }
        if (b3 != null) {
            nbt.func_74773_a("BlocksB3", b3);
        }
    }

    public static void readSubChunkFromNBTNotEnoughIDsDFU(SubChunkBlockHook subChunk, NBTTagCompound nbt) {
        byte[] data = nbt.func_74770_j("Blocks16");
        short[] dataShort = new short[data.length >>> 1];
        ByteBuffer.wrap(data).asShortBuffer().get(dataShort);
        byte[] b1 = new byte[4096];
        byte[] b2L = new byte[2048];
        byte[] b2H = new byte[2048];
        for (int i = 0; i < dataShort.length; ++i) {
            short s = dataShort[i];
            int nI = i >>> 1;
            int mI = (i & 1) * 4;
            b1[i] = (byte)(s & 0xFF);
            int n = nI;
            b2L[n] = (byte)(b2L[n] | (byte)((s & 0xF00) >>> 8 << mI));
            int n2 = nI;
            b2H[n2] = (byte)(b2H[n2] | (byte)((s & 0xF000) >>> 12 << mI));
        }
        subChunk.eid$setB1(b1);
        subChunk.eid$setB2Low(new NibbleArray(b2L, 4));
        subChunk.eid$setB2High(new NibbleArray(b2H, 4));
    }

    public void readSubChunkFromNBT(Chunk chunk, ExtendedBlockStorage subChunkVanilla, NBTTagCompound nbt) {
        SubChunkBlockHook subChunk = (SubChunkBlockHook)subChunkVanilla;
        if (nbt.func_74764_b("Blocks16")) {
            BlockIDManager.readSubChunkFromNBTNotEnoughIDsDFU(subChunk, nbt);
            return;
        }
        assert (nbt.func_74764_b("Blocks"));
        byte[] b1 = nbt.func_74770_j("Blocks");
        byte[] b2Low = nbt.func_74764_b("Add") ? nbt.func_74770_j("Add") : null;
        byte[] b2High = nbt.func_74764_b("BlocksB2Hi") ? nbt.func_74770_j("BlocksB2Hi") : null;
        byte[] b3 = nbt.func_74764_b("BlocksB3") ? nbt.func_74770_j("BlocksB3") : null;
        subChunk.eid$setB1(DataUtil.ensureSubChunkByteArray(b1));
        subChunk.eid$setB2Low(DataUtil.ensureSubChunkNibbleArray(b2Low));
        subChunk.eid$setB2High(DataUtil.ensureSubChunkNibbleArray(b2High));
        subChunk.eid$setB3(DataUtil.ensureSubChunkByteArray(b3));
    }

    public void cloneSubChunk(Chunk fromChunk, ExtendedBlockStorage fromVanilla, ExtendedBlockStorage toVanilla) {
        SubChunkBlockHook from = (SubChunkBlockHook)fromVanilla;
        SubChunkBlockHook to = (SubChunkBlockHook)toVanilla;
        to.eid$setB1(ArrayUtil.copyArray((byte[])from.eid$getB1(), (byte[])to.eid$getB1()));
        to.eid$setB2Low(ArrayUtil.copyArray((NibbleArray)from.eid$getB2Low(), (NibbleArray)to.eid$getB2Low()));
        to.eid$setB2High(ArrayUtil.copyArray((NibbleArray)from.eid$getB2High(), (NibbleArray)to.eid$getB2High()));
        to.eid$setB3(ArrayUtil.copyArray((byte[])from.eid$getB3(), (byte[])to.eid$getB3()));
    }

    @NotNull
    public String version() {
        return "1.6.14";
    }

    @Nullable
    public String newInstallDescription() {
        return "EndlessIDs extended block IDs. Vanilla worlds can be converted to EndlessIDs worlds safely.";
    }

    @NotNull
    public String uninstallMessage() {
        return "EndlessIDs extended block IDs removed. Any blocks with IDs above 4095 will get corrupted.";
    }

    @Nullable
    public String versionChangeMessage(String priorVersion) {
        return null;
    }

    public void writeBlockToPacket(Chunk chunk, int x, int y, int z, S23PacketBlockChange packet) {
    }

    public void readBlockFromPacket(Chunk chunk, int x, int y, int z, S23PacketBlockChange packet) {
    }

    public void writeBlockPacketToBuffer(S23PacketBlockChange packet, PacketBuffer buffer) {
        buffer.writeInt(Block.func_149682_b((Block)packet.field_148883_d));
    }

    public void readBlockPacketFromBuffer(S23PacketBlockChange packet, PacketBuffer buffer) {
        packet.field_148883_d = Block.func_149729_e((int)buffer.readInt());
    }
}

