/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.util;

import com.pam.harvestcraft.BlockPamCrop;
import cpw.mods.fml.common.Loader;
import iguanaman.hungeroverhaul.module.PamsModsHelper;
import iguanaman.hungeroverhaul.util.RandomHelper;
import java.util.ArrayList;
import java.util.List;
import mods.natura.blocks.crops.CropBlock;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BlockHelper {
    public static List<ItemStack> modifyCropDrops(List<ItemStack> drops, Block block, int meta, int minSeeds, int maxSeeds, int minProduce, int maxProduce) {
        ArrayList<ItemStack> modifiedDrops = new ArrayList<ItemStack>();
        int seeds = RandomHelper.getRandomIntFromRange(minSeeds, maxSeeds);
        int produce = RandomHelper.getRandomIntFromRange(minProduce, maxProduce);
        ItemStack seedItem = BlockHelper.getSeedsOfBlock(block, meta, seeds);
        ItemStack produceItem = BlockHelper.getProduceOfBlock(block, meta, produce);
        boolean produceIsNotSeed = seedItem.func_77973_b() != produceItem.func_77973_b() || seedItem.func_77960_j() != produceItem.func_77960_j();
        for (ItemStack item : drops) {
            if (item.func_77969_a(seedItem) || item.func_77969_a(produceItem)) continue;
            modifiedDrops.add(item);
        }
        if (produceIsNotSeed && seedItem.field_77994_a > 0) {
            modifiedDrops.add(seedItem);
        }
        if (produceItem.field_77994_a > 0) {
            modifiedDrops.add(produceItem);
        }
        return modifiedDrops;
    }

    public static ItemStack getSeedOfBlock(Block block, int meta) {
        return BlockHelper.getSeedsOfBlock(block, meta, 1);
    }

    public static ItemStack getSeedsOfBlock(Block block, int meta, int num) {
        return new ItemStack(BlockHelper.getSeedItem(block, meta), num, BlockHelper.getSeedMetadata(block, meta));
    }

    public static ItemStack getProduceOfBlock(Block block, int meta) {
        return BlockHelper.getProduceOfBlock(block, meta, 1);
    }

    public static ItemStack getProduceOfBlock(Block block, int meta, int num) {
        return new ItemStack(BlockHelper.getProduceItem(block, meta), num, BlockHelper.getProduceMetadata(block, meta));
    }

    public static Item getSeedItem(Block block, int meta) {
        Item seedForProduct;
        Item itemDropped = block.func_149650_a(0, RandomHelper.random, 0);
        if (Loader.isModLoaded((String)"harvestcraft") && block instanceof BlockPamCrop && (seedForProduct = PamsModsHelper.productToSeedMap.get(itemDropped)) != null) {
            return seedForProduct;
        }
        return itemDropped;
    }

    public static Item getProduceItem(Block block, int meta) {
        return block.func_149650_a(meta, RandomHelper.random, 0);
    }

    public static int getProduceMetadata(Block block, int meta) {
        return block.func_149692_a(meta);
    }

    public static int getSeedMetadata(Block block, int meta) {
        if (Loader.isModLoaded((String)"Natura") && block == NContent.crops) {
            return ((CropBlock)block).seedDamageDropped(meta);
        }
        return block.func_149692_a(0);
    }
}

