/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.lib.asm.ASMHelper;
import codechicken.lib.asm.CC_ClassWriter;
import codechicken.lib.asm.ObfMapping;
import codechicken.obfuscator.IHeirachyEvaluator;
import codechicken.obfuscator.ObfuscationMap;
import codechicken.obfuscator.ObfuscationRun;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.asm.transformers.AccessTransformer;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class MCPDeobfuscationTransformer
implements IClassTransformer,
Opcodes,
IHeirachyEvaluator {
    private static ObfuscationRun run;
    private static List<String> excludedPackages;
    private static MCPDeobfuscationTransformer instance;
    private static boolean activated;
    private static Field f_transformers;
    private static Field f_modifiers;
    private static Field f_Modifier_name;
    private static Field f_Modifier_desc;

    private static Object get(Field f, Object inst) {
        try {
            return f.get(inst);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void set(Field f, Object inst, Object value) {
        try {
            f.set(inst, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<IClassTransformer> getTransformers() {
        return (List)MCPDeobfuscationTransformer.get(f_transformers, Launch.classLoader);
    }

    public static void load() {
        run = new ObfuscationRun(false, ObfMapping.MCPRemapper.getConfFiles(), ObfuscationRun.fillDefaults(new HashMap<String, String>()));
        MCPDeobfuscationTransformer.run.obf.setHeirachyEvaluator(instance);
        run.setQuiet().parseMappings();
        Collections.addAll(excludedPackages, MCPDeobfuscationTransformer.run.config.get("excludedPackages").split(";"));
        if (ObfMapping.obfuscated) {
            ObfMapping.loadMCPRemapper();
            run.setSeargeConstants();
            MCPDeobfuscationTransformer.getTransformers().add(instance);
        } else {
            MCPDeobfuscationTransformer.getTransformers().add(0, instance);
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (name.equals("cpw.mods.fml.common.Loader")) {
            bytes = this.injectCallback(bytes);
            activated = true;
        }
        if (!activated || bytes == null) {
            return bytes;
        }
        ClassNode cnode = ASMHelper.createClassNode(bytes, 8);
        CC_ClassWriter cw = new CC_ClassWriter(0, true);
        run.remap(cnode, (ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] injectCallback(byte[] bytes) {
        ClassNode cnode = ASMHelper.createClassNode(bytes);
        MethodNode mnode = ASMHelper.findMethod(new ObfMapping(cnode.name, "<clinit>", "()V"), cnode);
        mnode.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, "codechicken/core/asm/MCPDeobfuscationTransformer", "loadCallback", "()V"));
        return ASMHelper.createBytes(cnode, 0);
    }

    public static void loadCallback() {
        if (ObfMapping.obfuscated) {
            List<IClassTransformer> transformers = MCPDeobfuscationTransformer.getTransformers();
            transformers.remove(instance);
            transformers.add(instance);
        } else {
            for (IClassTransformer t : MCPDeobfuscationTransformer.getTransformers()) {
                if (!(t instanceof AccessTransformer)) continue;
                MCPDeobfuscationTransformer.remapAccessTransformer(t);
            }
        }
    }

    private static void remapAccessTransformer(IClassTransformer t) {
        Multimap modifiers = (Multimap)MCPDeobfuscationTransformer.get(f_modifiers, t);
        HashMultimap t_modifiers = HashMultimap.create();
        for (Map.Entry entry : modifiers.entries()) {
            ObfMapping map;
            Object mod = entry.getValue();
            String m_owner = ((String)entry.getKey()).replace('.', '/');
            String m_name = (String)MCPDeobfuscationTransformer.get(f_Modifier_name, mod);
            String m_desc = ((String)MCPDeobfuscationTransformer.get(f_Modifier_desc, mod)).replace('.', '/');
            if (m_name.equals("*")) {
                map = new ObfMapping(m_owner);
                map.s_name = m_name;
                map.s_desc = m_desc;
            } else {
                try {
                    map = new ObfMapping(m_owner, m_name, m_desc).toClassloading();
                }
                catch (Exception e) {
                    new Object();
                    continue;
                }
            }
            MCPDeobfuscationTransformer.set(f_Modifier_name, mod, map.s_name);
            MCPDeobfuscationTransformer.set(f_Modifier_desc, mod, map.s_desc);
            t_modifiers.put((Object)map.javaClass(), mod);
        }
        MCPDeobfuscationTransformer.set(f_modifiers, t, t_modifiers);
    }

    @Override
    public List<String> getParents(ObfuscationMap.ObfuscationEntry desc) {
        String name = ObfMapping.obfuscated ? desc.obf.s_owner : desc.mcp.s_owner;
        name = name.replace('/', '.');
        try {
            byte[] bytes = Launch.classLoader.getClassBytes(name);
            if (bytes != null) {
                return ObfuscationRun.getParents(ASMHelper.createClassNode(bytes));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Launch.classLoader.clearNegativeEntries(Collections.singleton(name));
        return null;
    }

    @Override
    public boolean isLibClass(ObfuscationMap.ObfuscationEntry desc) {
        String name = desc.srg.s_owner;
        for (String p : excludedPackages) {
            if (!name.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    public static String unmap(String name) {
        if (run == null) {
            return null;
        }
        ObfuscationMap.ObfuscationEntry e = MCPDeobfuscationTransformer.run.obf.lookupMcpClass(name);
        if (e == null) {
            return null;
        }
        return e.obf.s_owner;
    }

    public static MCPDeobfuscationTransformer instance() {
        return instance;
    }

    static {
        excludedPackages = new LinkedList<String>();
        instance = new MCPDeobfuscationTransformer();
        try {
            f_transformers = LaunchClassLoader.class.getDeclaredField("transformers");
            f_modifiers = AccessTransformer.class.getDeclaredField("modifiers");
            Class<?> c_Modifier = Class.forName(AccessTransformer.class.getName() + "$Modifier", false, (ClassLoader)Launch.classLoader);
            f_Modifier_name = c_Modifier.getDeclaredField("name");
            f_Modifier_desc = c_Modifier.getDeclaredField("desc");
            f_transformers.setAccessible(true);
            f_modifiers.setAccessible(true);
            f_Modifier_name.setAccessible(true);
            f_Modifier_desc.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class LoadPlugin
    implements IFMLLoadingPlugin {
        public String[] getASMTransformerClass() {
            return null;
        }

        public String getModContainerClass() {
            return null;
        }

        public String getSetupClass() {
            return null;
        }

        public void injectData(Map<String, Object> data) {
            MCPDeobfuscationTransformer.load();
        }

        public String getAccessTransformerClass() {
            return null;
        }
    }
}

