/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import com.google.common.collect.ImmutableBiMap;
import cpw.mods.fml.common.asm.transformers.AccessTransformer;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.io.IOException;
import java.lang.reflect.Field;

public class CodeChickenAccessTransformer
extends AccessTransformer {
    private static final Field f_classNameBiMap;
    private static Object emptyMap;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        boolean setPublic = name.startsWith("net.minecraft.");
        if (setPublic) {
            CodeChickenAccessTransformer.setClassMap(name);
        }
        bytes = super.transform(name, transformedName, bytes);
        if (setPublic) {
            CodeChickenAccessTransformer.restoreClassMap();
        }
        return bytes;
    }

    private static void restoreClassMap() {
        try {
            f_classNameBiMap.set(FMLDeobfuscatingRemapper.INSTANCE, emptyMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void setClassMap(String name) {
        try {
            f_classNameBiMap.set(FMLDeobfuscatingRemapper.INSTANCE, ImmutableBiMap.of((Object)name.replace('.', '/'), (Object)""));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        emptyMap = ImmutableBiMap.of();
        try {
            f_classNameBiMap = FMLDeobfuscatingRemapper.class.getDeclaredField("classNameBiMap");
            f_classNameBiMap.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

