/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.render;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public final class RenderUtils {
    private RenderUtils() {
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static void drawBlockItem(RenderBlocks render, Tessellator tessellator, Block block, IIcon icon) {
        if (icon == null) {
            return;
        }
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        render.func_147768_a(block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        render.func_147806_b(block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        render.func_147761_c(block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        render.func_147734_d(block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        render.func_147798_e(block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        render.func_147764_f(block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78381_a();
    }

    public static void drawBlockItem(RenderBlocks render, Tessellator tessellator, Block block, int decodedMeta) {
        tessellator.func_78382_b();
        IIcon icon = RenderUtils.tryGetBlockIcon(block, 0, decodedMeta);
        if (icon != null) {
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            render.func_147768_a(block, 0.0, 0.0, 0.0, icon);
        }
        if ((icon = RenderUtils.tryGetBlockIcon(block, 1, decodedMeta)) != null) {
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            render.func_147806_b(block, 0.0, 0.0, 0.0, icon);
        }
        if ((icon = RenderUtils.tryGetBlockIcon(block, 2, decodedMeta)) != null) {
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            render.func_147761_c(block, 0.0, 0.0, 0.0, icon);
        }
        if ((icon = RenderUtils.tryGetBlockIcon(block, 3, decodedMeta)) != null) {
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            render.func_147734_d(block, 0.0, 0.0, 0.0, icon);
        }
        if ((icon = RenderUtils.tryGetBlockIcon(block, 4, decodedMeta)) != null) {
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            render.func_147798_e(block, 0.0, 0.0, 0.0, icon);
        }
        if ((icon = RenderUtils.tryGetBlockIcon(block, 5, decodedMeta)) != null) {
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            render.func_147764_f(block, 0.0, 0.0, 0.0, icon);
        }
        tessellator.func_78381_a();
    }

    public static IIcon tryGetBlockIcon(Block block, int side, int decodedMeta) {
        IIcon icon = null;
        try {
            icon = block.func_149691_a(side, decodedMeta);
        }
        catch (Throwable t) {
            try {
                icon = block.func_149733_h(side);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return icon;
    }
}

