/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.util;

import com.gtnewhorizons.wdmla.config.General;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class FormatUtil {
    public static final DecimalFormat STANDARD = FormatUtil.getDecimalFormat();
    public static final DecimalFormat TIME_PART = FormatUtil.getTimePartFormat();
    public static final DecimalFormat STANDARD_NO_GROUP = FormatUtil.getNoGroupFormat();
    public static final NumberFormat PERCENTAGE_STANDARD = FormatUtil.getPercentageStandardFormat();

    private static DecimalFormat getDecimalFormat() {
        NumberFormat format = NumberFormat.getNumberInstance(Locale.US);
        DecimalFormat decimalFormat = format instanceof DecimalFormat ? (DecimalFormat)format : new DecimalFormat();
        decimalFormat.setGroupingUsed(true);
        decimalFormat.setMaximumFractionDigits(2);
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        return decimalFormat;
    }

    private static DecimalFormat getTimePartFormat() {
        NumberFormat format = NumberFormat.getNumberInstance(Locale.US);
        DecimalFormat decimalFormat = format instanceof DecimalFormat ? (DecimalFormat)format : new DecimalFormat();
        decimalFormat.applyPattern("00");
        decimalFormat.setMaximumIntegerDigits(2);
        decimalFormat.setParseIntegerOnly(true);
        decimalFormat.setGroupingUsed(false);
        return decimalFormat;
    }

    private static DecimalFormat getNoGroupFormat() {
        NumberFormat format = NumberFormat.getNumberInstance(Locale.US);
        DecimalFormat decimalFormat = format instanceof DecimalFormat ? (DecimalFormat)format : new DecimalFormat();
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setMaximumFractionDigits(2);
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        return decimalFormat;
    }

    private static NumberFormat getPercentageStandardFormat() {
        NumberFormat percentFormat = NumberFormat.getPercentInstance(Locale.US);
        percentFormat.setGroupingUsed(false);
        percentFormat.setMaximumFractionDigits(0);
        percentFormat.setRoundingMode(RoundingMode.HALF_UP);
        return percentFormat;
    }

    public static String formatNameByPixelCount(String rawName) {
        if (rawName == null) {
            return null;
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int maxNameLength = General.maxNameLengthPixel;
        if (fontRenderer.func_78256_a(rawName) <= maxNameLength) {
            return rawName;
        }
        while (fontRenderer.func_78256_a(rawName) > maxNameLength) {
            rawName = rawName.substring(0, rawName.length() - 1);
        }
        return rawName + "...";
    }
}

