/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.vanilla;

import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.provider.IBlockComponentProvider;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.plugin.vanilla.VanillaIdentifiers;
import com.gtnewhorizons.wdmla.util.FormatUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public enum TotalEnchantmentPowerProvider implements IBlockComponentProvider
{
    INSTANCE;


    public float calculateEnchantPower(BlockAccessor accessor) {
        World worldPointer = accessor.getWorld();
        int posX = accessor.getHitResult().field_72311_b;
        int posY = accessor.getHitResult().field_72312_c;
        int posZ = accessor.getHitResult().field_72309_d;
        float power = 0.0f;
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                if (j == 0 && k == 0 || !worldPointer.func_147437_c(posX + k, posY, posZ + j) || !worldPointer.func_147437_c(posX + k, posY + 1, posZ + j)) continue;
                power += ForgeHooks.getEnchantPower((World)worldPointer, (int)(posX + k * 2), (int)posY, (int)(posZ + j * 2));
                power += ForgeHooks.getEnchantPower((World)worldPointer, (int)(posX + k * 2), (int)(posY + 1), (int)(posZ + j * 2));
                if (k == 0 || j == 0) continue;
                power += ForgeHooks.getEnchantPower((World)worldPointer, (int)(posX + k * 2), (int)posY, (int)(posZ + j));
                power += ForgeHooks.getEnchantPower((World)worldPointer, (int)(posX + k * 2), (int)(posY + 1), (int)(posZ + j));
                power += ForgeHooks.getEnchantPower((World)worldPointer, (int)(posX + k), (int)posY, (int)(posZ + j * 2));
                power += ForgeHooks.getEnchantPower((World)worldPointer, (int)(posX + k), (int)(posY + 1), (int)(posZ + j * 2));
            }
        }
        return power;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor) {
        float power = this.calculateEnchantPower(accessor);
        tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.total.enchantment.power"), FormatUtil.STANDARD.format(power)).tag(VanillaIdentifiers.TOTAL_ENCHANTMENT_POWER));
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaIdentifiers.TOTAL_ENCHANTMENT_POWER;
    }
}

