/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.vanilla;

import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.provider.IEntityComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.ITimeFormatConfigurable;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.config.PluginsConfig;
import com.gtnewhorizons.wdmla.config.WDMlaConfig;
import com.gtnewhorizons.wdmla.impl.format.TimeFormattingPattern;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.plugin.vanilla.VanillaIdentifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public enum AnimalProvider implements IEntityComponentProvider,
ITimeFormatConfigurable
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor) {
        this.ageTooltip(tooltip, accessor);
        this.breedCooldownTooltip(tooltip, accessor);
    }

    private void ageTooltip(ITooltip tooltip, EntityAccessor accessor) {
        EntityAnimal animal;
        if (!PluginsConfig.vanilla.animal.showAnimalGrowth) {
            return;
        }
        Entity entity = accessor.getEntity();
        if (entity instanceof EntityAnimal && (animal = (EntityAnimal)entity).func_70631_g_() && animal.func_70874_b() != 0) {
            int absTimeToGrow = Math.abs(animal.func_70874_b());
            TimeFormattingPattern timePattern = WDMlaConfig.instance().getTimeFormatter(this);
            tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.animal.growth"), timePattern.tickFormatter.apply(absTimeToGrow)).tag(VanillaIdentifiers.ANIMAL_GROWTH));
        }
    }

    private void breedCooldownTooltip(ITooltip tooltip, EntityAccessor accessor) {
        EntityAnimal animal;
        if (!PluginsConfig.vanilla.animal.showBreedCooldown) {
            return;
        }
        Entity entity = accessor.getEntity();
        if (entity instanceof EntityAnimal && !(animal = (EntityAnimal)entity).func_70631_g_() && animal.func_70874_b() != 0) {
            int absTimeBreedCooldown = Math.abs(animal.func_70874_b());
            TimeFormattingPattern timePattern = WDMlaConfig.instance().getTimeFormatter(this);
            tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.animal.breedcooldown"), timePattern.tickFormatter.apply(absTimeBreedCooldown)).tag(VanillaIdentifiers.ANIMAL_BREED));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaIdentifiers.ANIMAL;
    }

    @Override
    public TimeFormattingPattern getDefaultTimeFormatter() {
        return TimeFormattingPattern.HOUR_MIN_SEC;
    }
}

