/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.universal;

import com.gtnewhorizons.wdmla.api.accessor.Accessor;
import com.gtnewhorizons.wdmla.api.view.ViewGroup;
import com.gtnewhorizons.wdmla.plugin.universal.ItemIterator;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemCollector<T> {
    public static final int MAX_SIZE = 54;
    public static final ItemCollector<?> EMPTY = new ItemCollector(null);
    private final Object2IntMap<ItemStack> items = new Object2IntLinkedOpenHashMap();
    private final ItemIterator<T> iterator;
    public long version;
    public long lastTimeFinished;
    public boolean lastTimeIsEmpty;
    public List<ViewGroup<ItemStack>> mergedResult;

    public ItemCollector(ItemIterator<T> iterator) {
        this.iterator = iterator;
    }

    public List<ViewGroup<ItemStack>> update(Accessor accessor) {
        if (this.iterator == null) {
            return null;
        }
        T container = this.iterator.find(accessor);
        if (container == null) {
            return null;
        }
        long currentVersion = this.iterator.getVersion(container);
        long gameTime = accessor.getWorld().func_82737_E();
        if (this.mergedResult != null && this.iterator.isFinished()) {
            if (this.version == currentVersion) {
                return this.mergedResult;
            }
            if (this.lastTimeFinished + 5L > gameTime) {
                return this.mergedResult;
            }
            this.iterator.reset();
        }
        AtomicInteger count = new AtomicInteger();
        this.iterator.populate(container, 108).forEach(stack -> {
            count.incrementAndGet();
            if (stack != null) {
                int stackSize = stack.field_77994_a;
                ItemStack copyStack = stack.func_77946_l();
                copyStack.field_77994_a = 1;
                Object2IntMap.Entry match = this.items.object2IntEntrySet().stream().filter(entry -> ItemStack.func_77989_b((ItemStack)((ItemStack)entry.getKey()), (ItemStack)copyStack)).findFirst().orElse(null);
                if (match != null) {
                    match.setValue(match.getIntValue() + stackSize);
                } else {
                    this.items.put((Object)copyStack, stackSize);
                }
            }
        });
        this.iterator.afterPopulate(count.get());
        if (this.mergedResult != null && !this.iterator.isFinished()) {
            this.updateCollectingProgress(this.mergedResult.get(0));
            return this.mergedResult;
        }
        List partialResult = this.items.entrySet().stream().limit(54L).map(entry -> {
            ((ItemStack)entry.getKey()).field_77994_a = (Integer)entry.getValue();
            return (ItemStack)entry.getKey();
        }).collect(Collectors.toList());
        List<ViewGroup<ItemStack>> groups = Arrays.asList(this.updateCollectingProgress(new ViewGroup<ItemStack>(partialResult)));
        if (this.iterator.isFinished()) {
            this.mergedResult = groups;
            this.lastTimeIsEmpty = this.mergedResult.get((int)0).views.isEmpty();
            this.version = currentVersion;
            this.lastTimeFinished = gameTime;
            this.items.clear();
        }
        return groups;
    }

    protected ViewGroup<ItemStack> updateCollectingProgress(ViewGroup<ItemStack> group) {
        if (this.lastTimeIsEmpty && group.views.isEmpty()) {
            return group;
        }
        float progress = this.iterator.getCollectingProgress();
        NBTTagCompound data = group.getExtraData();
        if (Float.isNaN(progress) || progress >= 1.0f) {
            data.func_82580_o("Collecting");
        } else {
            data.func_74776_a("Collecting", progress);
        }
        return group;
    }
}

