/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.storagedrawers;

import com.gtnewhorizons.wdmla.api.accessor.Accessor;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.provider.IBlockComponentProvider;
import com.gtnewhorizons.wdmla.api.ui.IComponent;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.impl.ObjectDataCenter;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.plugin.storagedrawers.DrawerInfoHighlighter;
import com.gtnewhorizons.wdmla.plugin.storagedrawers.StorageDrawersPlugin;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import com.mojang.authlib.GameProfile;
import mcp.mobius.waila.overlay.DisplayUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public enum DrawersContentProvider implements IBlockComponentProvider
{
    INSTANCE;

    private final DrawerInfoHighlighter[] tracker = new DrawerInfoHighlighter[4];
    private MovingObjectPosition lastPos;

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (!(tileEntity instanceof TileEntityDrawers)) {
            return;
        }
        TileEntityDrawers drawers = (TileEntityDrawers)tileEntity;
        if (SecurityManager.hasAccess((GameProfile)accessor.getPlayer().func_146103_bH(), (IProtectable)drawers)) {
            this.appendDrawersContent(accessor, drawers, tooltip);
        } else {
            tooltip.child(ThemeHelper.INSTANCE.failure(StatCollector.func_74838_a((String)"hud.msg.wdmla.no.access")));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return StorageDrawersPlugin.path("content");
    }

    private void appendDrawersContent(Accessor accessor, TileEntityDrawers drawerTile, ITooltip tooltip) {
        for (int i = 0; i < drawerTile.getDrawerCount(); ++i) {
            ItemStack stack;
            if (!drawerTile.isDrawerEnabled(i)) continue;
            IDrawer drawer = drawerTile.getDrawer(i);
            if (!ObjectDataCenter.equals(accessor.getHitResult(), this.lastPos) || this.tracker[i] == null) {
                this.tracker[i] = new DrawerInfoHighlighter(drawer);
            }
            if ((stack = drawer.getStoredItemPrototype()) == null || stack.func_77973_b() == null) {
                tooltip.child(this.tracker[i].update(drawer));
                continue;
            }
            String displayName = DisplayUtil.stripSymbols(DisplayUtil.itemDisplayNameShortFormatted(stack));
            if (drawer.getStoredItemCount() == Integer.MAX_VALUE) {
                tooltip.horizontal().child(ThemeHelper.INSTANCE.smallItem(stack)).text(displayName + " [Inf]");
                continue;
            }
            if (drawer instanceof IFractionalDrawer && ((IFractionalDrawer)drawer).getConversionRate() > 1) {
                String text = displayName + (i == 0 ? " [" : " [+") + ((IFractionalDrawer)drawer).getStoredItemRemainder() + "]";
                tooltip.horizontal().child(ThemeHelper.INSTANCE.smallItem(stack)).text(text);
                continue;
            }
            IComponent itemLine = this.tracker[i].update(drawer);
            tooltip.horizontal().child(ThemeHelper.INSTANCE.smallItem(stack)).child(itemLine);
        }
        if (drawerTile.isUnlimited() || drawerTile.isVending()) {
            tooltip.text(StatCollector.func_74838_a((String)"hud.msg.wdmla.stack.limit") + ": Inf");
        } else {
            int limit = drawerTile.getDrawerCapacity() * drawerTile.getEffectiveStorageMultiplier();
            tooltip.horizontal().text(StatCollector.func_74838_a((String)"hud.msg.wdmla.stack.limit")).child(ThemeHelper.INSTANCE.info(String.format(": %d (x%d)", limit, drawerTile.getEffectiveStorageMultiplier())));
        }
        this.lastPos = accessor.getHitResult();
    }
}

