/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.harvestability;

import com.gtnewhorizons.wdmla.api.harvestability.EffectiveTool;
import com.gtnewhorizons.wdmla.api.harvestability.HarvestLevel;
import com.gtnewhorizons.wdmla.api.harvestability.HarvestabilityInfo;
import com.gtnewhorizons.wdmla.api.harvestability.HarvestabilityTestPhase;
import com.gtnewhorizons.wdmla.api.provider.HarvestHandler;
import com.gtnewhorizons.wdmla.plugin.harvestability.BaseHarvestLogicHandler;
import com.gtnewhorizons.wdmla.plugin.harvestability.HarvestabilityIdentifiers;
import com.gtnewhorizons.wdmla.plugin.harvestability.TinkersHarvestHandler;
import com.gtnewhorizons.wdmla.plugin.harvestability.proxy.ProxyGregTech;
import com.gtnewhorizons.wdmla.plugin.harvestability.proxy.ProxyTinkersConstruct;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public enum GregTechHarvestHandler implements HarvestHandler
{
    INSTANCE;


    @Override
    public boolean testHarvest(HarvestabilityInfo info, HarvestabilityTestPhase phase, EntityPlayer player, Block block, int meta, MovingObjectPosition position) {
        if (phase == HarvestabilityTestPhase.EFFECTIVE_TOOL_NAME) {
            if (info.getEffectiveTool().isSameTool(ProxyGregTech.toolWrench)) {
                info.setEffectiveTool(ProxyGregTech.toolWrench);
            } else if (info.getEffectiveTool().isSameTool(ProxyGregTech.toolWireCutter)) {
                info.setEffectiveTool(ProxyGregTech.toolWireCutter);
            }
        } else if (phase == HarvestabilityTestPhase.CURRENTLY_HARVESTABLE && player.func_70694_bm() != null) {
            info.setCurrentlyHarvestable(this.isCurrentlyHarvestable(player, block, meta, player.func_70694_bm(), info.getEffectiveTool(), info.getHarvestLevel()));
        }
        return true;
    }

    @Override
    public ResourceLocation getUid() {
        return HarvestabilityIdentifiers.GREGTECH;
    }

    @Override
    public Block getEffectiveBlock(EntityPlayer player, Block block, ItemStack itemForm, int meta, MovingObjectPosition position) {
        return this.isDisguised(block, itemForm, meta) ? Block.func_149634_a((Item)itemForm.func_77973_b()) : null;
    }

    @Override
    public Integer getEffectiveMeta(EntityPlayer player, Block block, ItemStack itemForm, int meta, MovingObjectPosition position) {
        return this.isDisguised(block, itemForm, meta) ? Integer.valueOf(itemForm.func_77960_j()) : null;
    }

    @Override
    public int getDefaultPriority() {
        return TinkersHarvestHandler.INSTANCE.getDefaultPriority() + 1000;
    }

    public boolean isDisguised(Block block, ItemStack itemForm, int meta) {
        return itemForm.func_77973_b() instanceof ItemBlock && !ProxyGregTech.isOreBlock(block, meta) && !ProxyGregTech.isCasing(block) && !ProxyGregTech.isMachine(block);
    }

    public boolean isCurrentlyHarvestable(EntityPlayer player, Block block, int meta, @NotNull ItemStack itemHeld, EffectiveTool effectiveTool, HarvestLevel harvestLevel) {
        boolean isHoldingTinkersTool = ProxyTinkersConstruct.hasToolTag(itemHeld);
        boolean isHeldToolCorrect = GregTechHarvestHandler.isHeldToolCorrect(player, block, meta, itemHeld, effectiveTool, isHoldingTinkersTool);
        boolean isAboveMinHarvestLevel = ProxyTinkersConstruct.canToolHarvestLevel(itemHeld, block, meta, harvestLevel);
        return isHeldToolCorrect && isAboveMinHarvestLevel || !ProxyGregTech.isMachine(block) && !isHoldingTinkersTool && ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)meta);
    }

    public static boolean isHeldToolCorrect(EntityPlayer player, Block block, int meta, @NotNull ItemStack itemHeld, EffectiveTool effectiveTool, boolean isHoldingTinkersTool) {
        if (ProxyGregTech.isMachine(block)) {
            return effectiveTool.isSameTool(ProxyGregTech.toolWrench) && ProxyGregTech.isWrench(itemHeld) || effectiveTool.isSameTool(ProxyGregTech.toolWireCutter) && ProxyGregTech.isWireCutter(itemHeld);
        }
        if (ProxyGregTech.isGTTool(itemHeld)) {
            return itemHeld.func_150998_b(block);
        }
        return BaseHarvestLogicHandler.canToolHarvestBlock(itemHeld, block) || !isHoldingTinkersTool && block.canHarvestBlock(player, meta);
    }
}

