/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.debug;

import com.gtnewhorizons.wdmla.api.Identifiers;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.provider.IBlockComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IEntityComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IToggleableProvider;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.config.PluginsConfig;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import cpw.mods.fml.common.registry.GameData;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.utils.Constants;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class RegistryDataProvider
implements IToggleableProvider {
    public static ForBlock getBlock() {
        return ForBlock.INSTANCE;
    }

    public static ForEntity getEntity() {
        return ForEntity.INSTANCE;
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.REGISTRY_DATA;
    }

    @Override
    public int getDefaultPriority() {
        return -9999;
    }

    @Override
    public boolean canToggleInGui() {
        return false;
    }

    public static class ForBlock
    extends RegistryDataProvider
    implements IBlockComponentProvider {
        private static final ForBlock INSTANCE = new ForBlock();

        @Override
        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor) {
            if (!ConfigHandler.instance().getConfig("general", Constants.CFG_WAILA_METADATA, true)) {
                return;
            }
            DisplayMode displayMode = PluginsConfig.debug.registryData.displayMode;
            int blockID = Block.func_149682_b((Block)accessor.getBlock());
            int meta = accessor.getMetadata();
            String registryName = GameData.getBlockRegistry().func_148750_c((Object)accessor.getBlock());
            if (displayMode == DisplayMode.SHORT || displayMode == DisplayMode.DETAILS && !accessor.showDetails()) {
                tooltip.text(String.format(SpecialChars.ITALIC + StatCollector.func_74838_a((String)"hud.msg.wdmla.block.registry.data.short"), blockID, meta, registryName));
            } else {
                tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.block.id"), String.valueOf(blockID)));
                tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.metadata"), String.valueOf(meta)));
                tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.registry.name"), registryName));
            }
        }
    }

    public static class ForEntity
    extends RegistryDataProvider
    implements IEntityComponentProvider {
        private static final ForEntity INSTANCE = new ForEntity();

        @Override
        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor) {
            if (!PluginsConfig.debug.registryData.entityRegistryData) {
                return;
            }
            DisplayMode displayMode = PluginsConfig.debug.registryData.displayMode;
            String registryName = (String)EntityList.field_75626_c.get(accessor.getEntity().getClass());
            int registryID = (Integer)EntityList.field_75622_f.get(registryName);
            int entityID = accessor.getEntity().func_145782_y();
            if (displayMode == DisplayMode.SHORT || displayMode == DisplayMode.DETAILS && !accessor.showDetails()) {
                tooltip.text(String.format(SpecialChars.ITALIC + StatCollector.func_74838_a((String)"hud.msg.wdmla.entity.registry.data.short"), registryID, entityID, registryName));
            } else {
                tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.registry.id"), String.valueOf(registryID)));
                tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.entity.id"), String.valueOf(entityID)));
                tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.registry.name"), registryName));
            }
        }
    }

    public static enum DisplayMode {
        SHORT,
        FULL,
        DETAILS;

    }
}

