/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui.style;

import com.gtnewhorizons.wdmla.api.ui.IDrawable;
import com.gtnewhorizons.wdmla.api.ui.style.IProgressStyle;
import com.gtnewhorizons.wdmla.config.General;
import org.jetbrains.annotations.Nullable;

public class ProgressStyle
implements IProgressStyle {
    private int filledColor;
    private int alternateFilledColor;
    @Nullable
    private IDrawable overlay;

    public ProgressStyle(int filledColor, int alternateFilledColor, @Nullable IDrawable overlay) {
        this.filledColor = filledColor;
        this.alternateFilledColor = alternateFilledColor;
        this.overlay = overlay;
    }

    public ProgressStyle() {
        this.filledColor = General.progressColor.filled;
        this.alternateFilledColor = General.progressColor.filled;
        this.overlay = null;
    }

    public ProgressStyle singleColor(int singleColor) {
        return this.color(singleColor, singleColor);
    }

    public ProgressStyle color(int filledColor, int alternateFilledColor) {
        this.filledColor = filledColor;
        this.alternateFilledColor = alternateFilledColor;
        return this;
    }

    public ProgressStyle overlay(IDrawable overlay) {
        this.overlay = overlay;
        return this;
    }

    @Override
    public int getFilledColor() {
        return this.filledColor;
    }

    @Override
    public int getAlternateFilledColor() {
        return this.alternateFilledColor;
    }

    @Override
    @Nullable
    public IDrawable getOverlay() {
        return this.overlay;
    }
}

