/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui.component;

import com.gtnewhorizons.wdmla.api.ui.sizer.ISize;
import com.gtnewhorizons.wdmla.api.ui.style.ITextStyle;
import com.gtnewhorizons.wdmla.impl.ui.component.Component;
import com.gtnewhorizons.wdmla.impl.ui.drawable.TextDrawable;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Area;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Padding;
import com.gtnewhorizons.wdmla.impl.ui.sizer.TextSize;
import com.gtnewhorizons.wdmla.impl.ui.style.TextStyle;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import org.jetbrains.annotations.NotNull;

public class TextComponent
extends Component {
    protected ITextStyle style = new TextStyle();

    public TextComponent(String text) {
        super(new Padding(), new TextSize(text), new TextDrawable(text));
    }

    public TextComponent style(ITextStyle style) {
        ((TextDrawable)this.foreground).style(style);
        this.style = style;
        return this;
    }

    public TextComponent scale(float scale) {
        ((TextSize)this.size).scale(scale);
        ((TextDrawable)this.foreground).scale(scale);
        return this;
    }

    @Override
    public TextComponent size(@NotNull ISize size) {
        throw new IllegalArgumentException("You can't set the size of TextComponent!");
    }

    @Override
    public void tick(float x, float y) {
        float width = this.size.getW();
        float height = this.size.getH();
        switch (this.style.getAlignment()) {
            case BOTTOMRIGHT: {
                this.foreground.draw(new Area(x + width + this.padding.getLeft(), y + this.padding.getTop(), width, height));
                break;
            }
            case CENTER: {
                this.foreground.draw(new Area(x + width / 2.0f + this.padding.getLeft(), y + this.padding.getTop(), width, height));
                break;
            }
            case TOPLEFT: {
                this.foreground.draw(new Area(x + this.padding.getLeft(), y + this.padding.getTop(), width, height));
                break;
            }
            default: {
                WailaExceptionHandler.handleErr(new IllegalArgumentException("invalid text alignment"), this.getClass().getName(), null);
            }
        }
    }
}

