/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl;

import com.gtnewhorizons.wdmla.api.accessor.Accessor;
import com.gtnewhorizons.wdmla.api.accessor.AccessorClientHandler;
import com.gtnewhorizons.wdmla.api.harvestability.HarvestabilityInfo;
import com.gtnewhorizons.wdmla.impl.WDMlaClientRegistration;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
public final class ObjectDataCenter {
    public static final int RATE_LIMIT_MP = 250;
    public static final int RATE_LIMIT_SP = 1;
    private static int rateLimiter = 250;
    public static long timeLastUpdate = System.currentTimeMillis();
    public static HarvestabilityInfo harvestabilityInfo;
    private static Accessor accessor;
    private static AccessorClientHandler<Accessor> clientHandler;
    private static NBTTagCompound serverData;
    private static MovingObjectPosition lastObject;

    private ObjectDataCenter() {
    }

    public static void set(@Nullable Accessor accessor) {
        ObjectDataCenter.accessor = accessor;
        if (accessor == null) {
            lastObject = null;
            clientHandler = null;
            return;
        }
        clientHandler = WDMlaClientRegistration.instance().getAccessorHandler(accessor.getAccessorType());
        MovingObjectPosition object = accessor.getHitResult();
        if (!ObjectDataCenter.equals(object, lastObject)) {
            lastObject = object;
            serverData = null;
            harvestabilityInfo = null;
            ObjectDataCenter.requestServerData();
        }
    }

    @Nullable
    public static Accessor get() {
        return accessor;
    }

    public static NBTTagCompound getServerData() {
        if (accessor == null || clientHandler == null || serverData == null) {
            return null;
        }
        if (accessor.verifyData(serverData)) {
            return serverData;
        }
        ObjectDataCenter.requestServerData();
        return null;
    }

    public static void setServerData(NBTTagCompound tag) {
        serverData = tag;
        if (accessor == null) {
            return;
        }
        if (accessor.verifyData(serverData)) {
            accessor.getServerData().func_150296_c().clear();
            for (String s : tag.func_150296_c()) {
                NBTBase nbt = tag.func_74781_a(s);
                accessor.getServerData().func_74782_a(s, nbt);
            }
        }
    }

    public static void requestServerData() {
        timeLastUpdate = System.currentTimeMillis() - (long)rateLimiter;
    }

    public static boolean isRequestTimeElapsed() {
        return System.currentTimeMillis() - timeLastUpdate >= (long)rateLimiter;
    }

    public static void resetTimer() {
        timeLastUpdate = System.currentTimeMillis();
        rateLimiter = Minecraft.func_71410_x().func_71356_B() ? 1 : 250;
    }

    public static boolean equals(MovingObjectPosition mop1, MovingObjectPosition mop2) {
        if (mop1 != null && mop1.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && mop2 != null && mop2.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return mop1.field_72311_b == mop2.field_72311_b && mop1.field_72312_c == mop2.field_72312_c && mop1.field_72309_d == mop2.field_72309_d;
        }
        if (mop1 != null && mop1.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && mop2 != null && mop2.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            return mop1.field_72308_g.func_145782_y() == mop2.field_72308_g.func_145782_y();
        }
        return false;
    }

    public static void setHarvestabilityInfo(HarvestabilityInfo info) {
        harvestabilityInfo = info;
    }

    public static boolean canCurrentTargetBeHarvested() {
        return harvestabilityInfo == null || harvestabilityInfo.isCurrentlyHarvestable();
    }

    static {
        serverData = new NBTTagCompound();
    }
}

