/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.api.ui;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import net.minecraft.util.MathHelper;

public class HighlightTracker<T> {
    private T currentValue;
    private Instant lastUpdate = Instant.now().minus(DETAILED_DURATION);
    private static final Duration DETAILED_DURATION = Duration.ofMillis(1500L);

    public HighlightTracker(T initValue) {
        this.currentValue = initValue;
    }

    public void resetTimer() {
        this.lastUpdate = Instant.now();
    }

    public boolean isRecentlyUpdated() {
        return Duration.between(this.lastUpdate, Instant.now()).compareTo(DETAILED_DURATION) < 0;
    }

    public boolean update(T newValue) {
        if (this.isSame(this.currentValue, newValue)) {
            return this.isRecentlyUpdated();
        }
        this.currentValue = newValue;
        this.resetTimer();
        return true;
    }

    public boolean isSame(T object1, T object2) {
        return Objects.equals(object1, object2);
    }

    public float getInterpolation() {
        long elapsedMillis = Duration.between(this.lastUpdate, Instant.now()).toMillis();
        long totalMillis = DETAILED_DURATION.toMillis();
        return MathHelper.func_76131_a((float)((float)elapsedMillis / (float)totalMillis), (float)0.0f, (float)1.0f);
    }

    public static class ItemStack
    extends HighlightTracker<net.minecraft.item.ItemStack> {
        public ItemStack(net.minecraft.item.ItemStack initValue) {
            super(initValue);
        }

        @Override
        public boolean isSame(net.minecraft.item.ItemStack object1, net.minecraft.item.ItemStack object2) {
            return net.minecraft.item.ItemStack.func_77989_b((net.minecraft.item.ItemStack)object1, (net.minecraft.item.ItemStack)object2);
        }
    }
}

