/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world.biome;

import cofh.lib.world.biome.BiomeInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeInfoSet
implements Set<BiomeInfo> {
    protected BiomeInfo[] elementData;
    protected int size;
    protected int modCount;

    public BiomeInfoSet() {
        this(10);
    }

    public BiomeInfoSet(int n) {
        this.elementData = new BiomeInfo[n];
    }

    public BiomeInfoSet(Collection<? extends BiomeInfo> collection) {
        this.elementData = collection.toArray(new BiomeInfo[collection.size()]);
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = Arrays.copyOf(this.elementData, n3);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object object) {
        BiomeInfo[] biomeInfoArray = this.elementData;
        if (object instanceof BiomeGenBase) {
            BiomeGenBase biomeGenBase = (BiomeGenBase)object;
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (biomeInfoArray[i] == null || !biomeInfoArray[i].isBiomeEqual(biomeGenBase, null)) continue;
                return true;
            }
            return false;
        }
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (biomeInfoArray[i] != object && (biomeInfoArray[i] == null || object == null || !biomeInfoArray[i].equals(object))) continue;
            return true;
        }
        return false;
    }

    public boolean contains(BiomeGenBase biomeGenBase, Random random) {
        BiomeInfo[] biomeInfoArray = this.elementData;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (biomeInfoArray[i] == null || !biomeInfoArray[i].isBiomeEqual(biomeGenBase, random)) continue;
            return true;
        }
        return false;
    }

    public BiomeInfo get(int n) {
        if (n < 0 | n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.elementData[n];
    }

    @Override
    public Iterator<BiomeInfo> iterator() {
        return new Itr();
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elementData, this.size, Object[].class);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (TArray.length < this.size) {
            return Arrays.copyOf(this.elementData, this.size, TArray.getClass());
        }
        System.arraycopy(this.elementData, 0, TArray, 0, this.size);
        if (TArray.length > this.size) {
            TArray[this.size] = null;
        }
        return TArray;
    }

    @Override
    public boolean add(BiomeInfo biomeInfo) {
        int n = this.size;
        this.size = n + 1;
        this.ensureCapacity(this.size);
        this.elementData[n] = biomeInfo;
        return true;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (this.elementData[i] != object) continue;
            this.fastRemove(i);
            return true;
        }
        return false;
    }

    protected void fastRemove(int n) {
        ++this.modCount;
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        boolean bl = true;
        for (Object obj : collection) {
            bl |= this.contains(obj);
        }
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends BiomeInfo> collection) {
        int n = collection.size();
        if (n == 0) {
            return false;
        }
        BiomeInfo[] biomeInfoArray = collection.toArray(new BiomeInfo[n]);
        this.ensureCapacity(this.size + n);
        System.arraycopy(biomeInfoArray, 0, this.elementData, this.size, n);
        this.size += n;
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        BiomeInfo[] biomeInfoArray = this.elementData;
        int n = biomeInfoArray.length;
        this.elementData = new BiomeInfo[collection.size() / 2];
        this.size = 0;
        boolean bl = true;
        for (Object obj : collection) {
            for (int i = 0; i < n; ++i) {
                if (biomeInfoArray[i] != obj && (biomeInfoArray[i] == null || obj == null || !biomeInfoArray[i].equals(obj))) continue;
                bl |= this.add(biomeInfoArray[i]);
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = true;
        for (Object obj : collection) {
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    protected class Itr
    implements Iterator<BiomeInfo> {
        protected int cursor = 0;
        protected int expectedModCount;
        protected boolean lastRet;

        protected Itr() {
            this.expectedModCount = BiomeInfoSet.this.modCount;
            this.lastRet = false;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != BiomeInfoSet.this.size;
        }

        @Override
        public BiomeInfo next() {
            this.checkForComodification();
            try {
                if (this.cursor < BiomeInfoSet.this.size) {
                    this.lastRet = true;
                    return BiomeInfoSet.this.elementData[this.cursor++];
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (!this.lastRet) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                this.lastRet = false;
                BiomeInfoSet.this.remove(--this.cursor);
                this.expectedModCount = BiomeInfoSet.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        protected final void checkForComodification() {
            if (BiomeInfoSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

