/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.bluepower;

import buildcraft.transport.TileGenericPipeCompat;
import com.bluepowermod.api.BPApi;
import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.connect.IConnectionCache;
import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BundledDevicePipe
implements IBundledDevice {
    private final TileGenericPipeCompat tile;
    private final IConnectionCache<? extends IBundledDevice> cache;

    public BundledDevicePipe(TileGenericPipeCompat tile) {
        this.tile = tile;
        this.cache = BPApi.getInstance().getRedstoneApi().createBundledConnectionCache((IBundledDevice)this);
    }

    public boolean canConnect(ForgeDirection side, IBundledDevice dev, ConnectionType type) {
        return type == ConnectionType.STRAIGHT && side != ForgeDirection.UNKNOWN && !this.tile.hasBlockingPluggable(side);
    }

    public IConnectionCache<? extends IBundledDevice> getBundledConnectionCache() {
        return this.cache;
    }

    public byte[] getBundledOutput(ForgeDirection side) {
        return (byte[])this.tile.bundledCableSent[side.ordinal()].clone();
    }

    public void setBundledPower(ForgeDirection side, byte[] power) {
        if (power.length == 16) {
            this.tile.bundledCableReceived[side.ordinal()] = (byte[])power.clone();
        }
    }

    public byte[] getBundledPower(ForgeDirection side) {
        return (byte[])this.tile.bundledCableReceived[side.ordinal()].clone();
    }

    public void onBundledUpdate() {
        this.tile.scheduleNeighborChange();
    }

    public MinecraftColor getBundledColor(ForgeDirection side) {
        return MinecraftColor.NONE;
    }

    public boolean isNormalFace(ForgeDirection side) {
        return true;
    }

    public World getWorld() {
        return this.tile.func_145831_w();
    }

    public int getX() {
        return this.tile.field_145851_c;
    }

    public int getY() {
        return this.tile.field_145848_d;
    }

    public int getZ() {
        return this.tile.field_145849_e;
    }
}

