/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.item;

import com.gtnewhorizon.gtnhlib.capability.item.ItemIO;
import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import com.gtnewhorizon.gtnhlib.item.InsertionItemStack;
import com.gtnewhorizon.gtnhlib.item.InventoryIterator;
import com.gtnewhorizon.gtnhlib.item.ItemStack2IntFunction;
import com.gtnewhorizon.gtnhlib.item.ItemStackPredicate;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleItemIO
implements ItemIO {
    protected int[] allowedSourceSlots;
    protected int[] allowedSinkSlots;

    @Override
    public void resetSink() {
        this.allowedSinkSlots = null;
    }

    @Override
    public void resetSource() {
        this.allowedSourceSlots = null;
    }

    @Override
    public void setAllowedSinkSlots(int @Nullable [] slots) {
        this.allowedSinkSlots = slots;
    }

    @Override
    public void setAllowedSourceSlots(int @Nullable [] slots) {
        this.allowedSourceSlots = slots;
    }

    @Override
    @Nullable
    public ItemStack pull(@Nullable ItemStackPredicate filter, @Nullable ItemStack2IntFunction amount) {
        InventoryIterator iter = this.sourceIterator();
        while (iter.hasNext()) {
            ImmutableItemStack stack = (ImmutableItemStack)iter.next();
            if (stack == null || stack.isEmpty() || filter != null && !filter.test(stack)) continue;
            int toExtract = amount == null ? stack.getStackSize() : amount.apply(stack);
            return iter.extract(toExtract, false);
        }
        return null;
    }

    @Override
    public int store(ImmutableItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return 0;
        }
        InventoryIterator iter = this.sinkIterator();
        InsertionItemStack insertion = new InsertionItemStack(stack);
        while (iter.hasNext()) {
            iter.next();
            insertion.set(iter.insert(insertion, false));
            if (!insertion.isEmpty()) continue;
            return 0;
        }
        return insertion.getStackSize();
    }

    @Override
    @NotNull
    public InventoryIterator sourceIterator() {
        return this.iterator(this.allowedSourceSlots);
    }

    @Override
    @NotNull
    public InventoryIterator sinkIterator() {
        return this.iterator(this.allowedSinkSlots);
    }

    @NotNull
    protected abstract InventoryIterator iterator(int[] var1);
}

